/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.ICreationCommand;
import org.eclipse.papyrus.commands.OpenDiagramCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModelUtils;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.Messages;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractPapyrusGmfCreateDiagramCommandHandler
extends AbstractHandler
implements IHandler,
ICreationCommand {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ServicesRegistry registry;
        try {
            registry = ServiceUtilsForHandlers.getInstance().getServiceRegistry(event);
        }
        catch (ServiceException ex) {
            throw new ExecutionException("Cannot retrieve the ServicesRegistry", (Throwable)ex);
        }
        EObject container = null;
        container = this.getSelectedElement();
        this.runAsTransaction(container, registry);
        return null;
    }

    protected void runAsTransaction(EObject container, ServicesRegistry registry) throws ExecutionException {
        ModelSet modelSet;
        try {
            modelSet = (ModelSet)registry.getService(ModelSet.class);
        }
        catch (ServiceException e) {
            throw new ExecutionException("Can't get ModelSet", (Throwable)e);
        }
        this.runAsTransaction(modelSet, container, null);
    }

    protected void runAsTransaction(ModelSet modelSet, EObject container, String name) {
        TransactionalEditingDomain dom = modelSet.getTransactionalEditingDomain();
        CompositeCommand cmd = new CompositeCommand("Create diagram");
        ICommand createCmd = this.getCreateDiagramCommand(modelSet, container, name);
        cmd.add((IUndoableOperation)createCmd);
        cmd.add((IUndoableOperation)new OpenDiagramCommand(dom, createCmd));
        dom.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)cmd));
    }

    protected EObject getRootElement(Resource modelResource) {
        Object root;
        EObject rootElement = null;
        if (modelResource != null && modelResource.getContents() != null && modelResource.getContents().size() > 0 && (root = modelResource.getContents().get(0)) instanceof EObject) {
            rootElement = (EObject)root;
        }
        return rootElement;
    }

    protected void attachModelToResource(EObject root, Resource resource) {
        resource.getContents().add((Object)root);
    }

    public String getCreatedDiagramType() {
        return this.getDiagramNotationID();
    }

    protected abstract String getDiagramNotationID();

    protected abstract PreferencesHint getPreferenceHint();

    protected abstract String getDefaultDiagramName();

    protected EObject getSelectedElement() {
        EObject eObject = null;
        Object selection = this.getCurrentSelection();
        if (selection != null) {
            eObject = EMFHelper.getEObject((Object)selection);
        }
        return eObject;
    }

    private Object getCurrentSelection() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.getFirstElement();
        }
        return null;
    }

    protected Diagram createDiagram(Resource diagramResource, EObject owner, String name) {
        Diagram diagram = ViewService.createDiagram((EObject)owner, (String)this.getDiagramNotationID(), (PreferencesHint)this.getPreferenceHint());
        if (diagram != null) {
            diagram.setName(name);
            diagram.setElement(owner);
            this.initializeDiagram((EObject)diagram);
            diagramResource.getContents().add((Object)diagram);
        }
        return diagram;
    }

    protected void initializeDiagram(EObject diagram) {
    }

    protected IMultiDiagramEditor getMultiDiagramEditor() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        return (IMultiDiagramEditor)editorPart;
    }

    protected String openDiagramNameDialog(String defaultValue) {
        InputDialog inputDialog;
        int result;
        if (defaultValue == null) {
            defaultValue = "";
        }
        if ((result = (inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.AbstractPapyrusGmfCreateDiagramCommandHandler_SelectNewDiagramName, Messages.AbstractPapyrusGmfCreateDiagramCommandHandler_NewDiagramName, defaultValue, null)).open()) == 0) {
            String name = inputDialog.getValue();
            if (name == null || name.length() == 0) {
                name = defaultValue;
            }
            return name;
        }
        return null;
    }

    public void createDiagram(ModelSet modelSet, EObject container, String diagramName) {
        this.runAsTransaction(modelSet, container, diagramName);
    }

    public ICommand getCreateDiagramCommand(ModelSet modelSet, final EObject container, final String diagramName) {
        final Resource modelResource = UmlUtils.getUmlResource((ModelSet)modelSet);
        final Resource notationResource = NotationUtils.getNotationResource(modelSet);
        final Resource diResource = DiModelUtils.getDiResource((ModelSet)modelSet);
        ArrayList<IFile> modifiedFiles = new ArrayList<IFile>();
        if (notationResource.getURI().isPlatformResource()) {
            modifiedFiles.add(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(notationResource.getURI().toPlatformString(true))));
        }
        if (diResource.getURI().isPlatformResource()) {
            modifiedFiles.add(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(diResource.getURI().toPlatformString(true))));
        }
        return new AbstractTransactionalCommand(modelSet.getTransactionalEditingDomain(), Messages.AbstractPapyrusGmfCreateDiagramCommandHandler_CreateDiagramCommandLabel, modifiedFiles){
            protected Diagram diagram;
            protected EObject modelElement;

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                String name = diagramName;
                if (name == null) {
                    name = AbstractPapyrusGmfCreateDiagramCommandHandler.this.openDiagramNameDialog(AbstractPapyrusGmfCreateDiagramCommandHandler.this.getDefaultDiagramName());
                }
                if (name == null) {
                    return CommandResult.newCancelledCommandResult();
                }
                EObject model = container;
                if (model == null) {
                    model = AbstractPapyrusGmfCreateDiagramCommandHandler.this.getRootElement(modelResource);
                    AbstractPapyrusGmfCreateDiagramCommandHandler.this.attachModelToResource(model, modelResource);
                }
                this.diagram = AbstractPapyrusGmfCreateDiagramCommandHandler.this.createDiagram(notationResource, model, name);
                if (this.diagram != null) {
                    try {
                        IPageManager pageManager = ServiceUtilsForResource.getInstance().getIPageManager((Object)diResource);
                        pageManager.addPage((Object)this.diagram);
                        return CommandResult.newOKCommandResult((Object)this.diagram);
                    }
                    catch (ServiceException ex) {
                        Activator.log.error((Throwable)ex);
                        return CommandResult.newErrorCommandResult((Throwable)ex);
                    }
                }
                return CommandResult.newErrorCommandResult((String)"Error during diagram creation");
            }

            protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                IStatus status = super.doUndo(monitor, info);
                this.modelElement = this.diagram.getElement();
                this.diagram.setElement(null);
                return status;
            }

            protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                this.diagram.setElement(this.modelElement);
                IStatus status = super.doRedo(monitor, info);
                return status;
            }
        };
    }

    protected ISashWindowsContentProvider getISashWindowsContentProvider(ServicesRegistry registry) {
        try {
            return (ISashWindowsContentProvider)registry.getService(ISashWindowsContentProvider.class);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }

    public boolean isParentReassignable() {
        return true;
    }
}

