/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandUtilities;
import org.eclipse.gmf.runtime.diagram.ui.commands.PopupMenuCommand;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.DefaultActionHandler;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectAndExecuteCommand
extends PopupMenuCommand {
    private Command _selectedCmd;
    private DefaultActionHandler defaultHandler;

    public SelectAndExecuteCommand(String label, Shell parentShell, List<Command> content) {
        this(label, parentShell, content, null);
    }

    public SelectAndExecuteCommand(String label, Shell parentShell, List<Command> content, DefaultActionHandler handler) {
        super(label, parentShell);
        this.defaultHandler = handler;
        this.createPopupMenu(content);
    }

    protected void createPopupMenu(List<Command> content) {
        PopupMenu popupMenu;
        if (this.defaultHandler != null) {
            LinkedList<Command> menuContents = new LinkedList<Command>(content);
            PopupMenu submenu = new PopupMenu(this.convertToDefault(content), (ILabelProvider)new CommandLabelProvider());
            PopupMenu.CascadingMenu cascadingMenu = new PopupMenu.CascadingMenu((Object)this.defaultHandler.getLabel(), submenu);
            menuContents.add((Command)cascadingMenu);
            popupMenu = new PopupMenu(menuContents, (ILabelProvider)new CommandLabelProvider());
        } else {
            popupMenu = new PopupMenu(content, (ILabelProvider)new CommandLabelProvider());
        }
        this.setPopupMenu(popupMenu);
    }

    protected List<Command> convertToDefault(List<Command> commands) {
        ArrayList<Command> result = new ArrayList<Command>(commands.size());
        Iterator<Command> iterator = commands.iterator();
        while (iterator.hasNext()) {
            Command command;
            final Command commandToExecute = command = iterator.next();
            CompoundCommand compound = new CompoundCommand(commandToExecute.getLabel());
            compound.add(commandToExecute);
            compound.add(new Command("Set default drop behavior"){

                public void execute() {
                    SelectAndExecuteCommand.this.defaultHandler.defaultActionSelected(commandToExecute);
                }
            });
            result.add((Command)compound);
        }
        return result;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult cmdResult = super.doExecuteWithResult(progressMonitor, info);
        if (!cmdResult.getStatus().isOK()) {
            if (cmdResult.getStatus().getSeverity() != 8) {
                Activator.log.error(cmdResult.getStatus().getException());
            }
            return cmdResult;
        }
        Object returnValue = cmdResult.getReturnValue();
        this._selectedCmd = returnValue instanceof List ? (Command)((List)returnValue).get(((List)returnValue).size() - 1) : (Command)cmdResult.getReturnValue();
        Assert.isTrue((this._selectedCmd != null && this._selectedCmd.canExecute() ? 1 : 0) != 0);
        this._selectedCmd.execute();
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this._selectedCmd != null && this._selectedCmd.canUndo()) {
            this._selectedCmd.undo();
        }
        return super.doUndoWithResult(progressMonitor, info);
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this._selectedCmd != null && CommandUtilities.canRedo((Command)this._selectedCmd)) {
            this._selectedCmd.redo();
        }
        return super.doRedoWithResult(progressMonitor, info);
    }

    public static class CommandLabelProvider
    extends LabelProvider {
        public String getText(Object object) {
            String commandLabel;
            String text = super.getText(object);
            if (object instanceof Command && (commandLabel = ((Command)object).getLabel()) != null) {
                text = commandLabel;
            }
            return text;
        }
    }
}

