/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.port.xtext.validation;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.BoundSpecification;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.MultiplicityRule;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.PortRule;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.RedefinesRule;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.SubsetsRule;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.UmlPortPackage;
import org.eclipse.papyrus.uml.textedit.port.xtext.validation.AbstractUmlPortJavaValidator;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Port;
import org.eclipse.xtext.validation.Check;

public class UmlPortJavaValidator
extends AbstractUmlPortJavaValidator {
    private static Namespace model;
    private static Element contextElement;
    private static boolean valid_MultiplicityRule;
    private static boolean valid_RedefinesRule;
    private static boolean valid_SubsetsRule;

    static {
        valid_MultiplicityRule = true;
        valid_RedefinesRule = true;
        valid_SubsetsRule = true;
    }

    public static void init(Element _contextElement) {
        contextElement = _contextElement;
        if (contextElement != null) {
            Element elem = contextElement.getOwner();
            while (elem.getOwner() != null) {
                elem = elem.getOwner();
            }
            model = (Namespace)elem;
        }
    }

    public static Namespace getModel() {
        return model;
    }

    public static Element getContextElement() {
        return contextElement;
    }

    public static boolean validate() {
        return valid_MultiplicityRule && valid_RedefinesRule && valid_SubsetsRule;
    }

    @Check
    public void checkMultiplicityRule(MultiplicityRule rule) {
        int lowerValue = 0;
        int upperValue = 0;
        String errorMessage = "The upper bound of a multiplicity cannot be lower than the lower bound.";
        try {
            if (rule.getBounds().size() == 2) {
                lowerValue = ((BoundSpecification)rule.getBounds().get(0)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)rule.getBounds().get(0)).getValue());
                int n = upperValue = ((BoundSpecification)rule.getBounds().get(1)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)rule.getBounds().get(1)).getValue());
                if (lowerValue == -1 && upperValue != -1 || lowerValue > upperValue && upperValue != -1) {
                    this.error(errorMessage, (EStructuralFeature)UmlPortPackage.eINSTANCE.getBoundSpecification_Value());
                    valid_MultiplicityRule = false;
                } else {
                    valid_MultiplicityRule = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Check
    public void checkRedefinesRule(RedefinesRule rule) {
        try {
            Port redefinedProperty = rule.getPort();
            String typeErrorMessage = "The type of the redefining property must conform to the type of the redefined property";
            String multiplicityErrorMessage = "The multiplicity of the redefining property must be contained in the multiplicity of the redefined property";
            String isDerivedErrorMessage = "Since the redefined property is derived, the redefining property must be derived";
            EObject container = rule.eContainer();
            while (container != null && !(container instanceof PortRule)) {
                container = container.eContainer();
            }
            if (container == null) {
                return;
            }
            PortRule propertyRule = (PortRule)container;
            Classifier typeOfRedefiningProperty = propertyRule.getType().getType();
            boolean isRedefiningPropertyDerived = propertyRule.getIsDerived() != null && propertyRule.getIsDerived().equals("/");
            valid_RedefinesRule = typeOfRedefiningProperty.conformsTo(redefinedProperty.getType());
            if (!valid_RedefinesRule) {
                this.error(typeErrorMessage, (EStructuralFeature)UmlPortPackage.eINSTANCE.getRedefinesRule_Port());
                return;
            }
            int lowerBoundOfRedefinedProperty = redefinedProperty.getLower();
            int upperBoundOfRedefinedProperty = redefinedProperty.getUpper();
            int lowerBound = 1;
            int upperBound = 1;
            if (propertyRule.getMultiplicity() != null) {
                if (propertyRule.getMultiplicity().getBounds().size() == 1) {
                    upperBound = lowerBound = ((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue());
                } else if (propertyRule.getMultiplicity().getBounds().size() == 2) {
                    lowerBound = ((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue());
                    upperBound = ((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(1)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(1)).getValue());
                }
            }
            valid_RedefinesRule = lowerBound >= lowerBoundOfRedefinedProperty;
            switch (upperBoundOfRedefinedProperty) {
                case -1: {
                    break;
                }
                default: {
                    boolean bl = valid_RedefinesRule = valid_RedefinesRule && upperBound <= upperBoundOfRedefinedProperty;
                }
            }
            if (!valid_RedefinesRule) {
                this.error(multiplicityErrorMessage, (EStructuralFeature)UmlPortPackage.eINSTANCE.getRedefinesRule_Port());
                return;
            }
            if (redefinedProperty.isDerived() && !isRedefiningPropertyDerived) {
                valid_RedefinesRule = false;
            }
            if (!valid_RedefinesRule) {
                this.error(multiplicityErrorMessage, (EStructuralFeature)UmlPortPackage.eINSTANCE.getRedefinesRule_Port());
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Check
    public void checkSubsetsRule(SubsetsRule rule) {
        try {
            Port subsettedProperty = rule.getPort();
            String typeErrorMessage = "The type of the subsetting property must conform to the type of the subsetted property";
            String multiplicityErrorMessage = "The multiplicity of the subsetting property must be contained in the multiplicity of the subsetted property";
            EObject container = rule.eContainer();
            while (container != null && !(container instanceof PortRule)) {
                container = container.eContainer();
            }
            if (container == null) {
                return;
            }
            PortRule propertyRule = (PortRule)container;
            Classifier typeOfSubsettingProperty = propertyRule.getType().getType();
            valid_SubsetsRule = typeOfSubsettingProperty.conformsTo(subsettedProperty.getType());
            if (!valid_SubsetsRule) {
                this.error(multiplicityErrorMessage, (EStructuralFeature)UmlPortPackage.eINSTANCE.getSubsetsRule_Port());
                return;
            }
            int lowerBoundOfRedefinedProperty = subsettedProperty.getLower();
            int upperBoundOfRedefinedProperty = subsettedProperty.getUpper();
            int lowerBound = 1;
            int upperBound = 1;
            if (propertyRule.getMultiplicity() != null) {
                if (propertyRule.getMultiplicity().getBounds().size() == 1) {
                    upperBound = lowerBound = ((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue());
                } else if (propertyRule.getMultiplicity().getBounds().size() == 2) {
                    lowerBound = ((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue());
                    upperBound = ((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(1)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(1)).getValue());
                }
            }
            valid_SubsetsRule = lowerBound >= lowerBoundOfRedefinedProperty;
            switch (upperBoundOfRedefinedProperty) {
                case -1: {
                    break;
                }
                default: {
                    boolean bl = valid_SubsetsRule = valid_SubsetsRule && upperBound <= upperBoundOfRedefinedProperty;
                }
            }
            if (!valid_SubsetsRule) {
                this.error(multiplicityErrorMessage, (EStructuralFeature)UmlPortPackage.eINSTANCE.getSubsetsRule_Port());
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

