/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.handlers.GraphicalCommandHandler;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.TickUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.TimeRulerUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.DestructionOccurrenceSpecificationEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.MessageOccurrenceSpecificationEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.OccurrenceSpecificationEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLViewProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class CreateTickCommand
extends GraphicalCommandHandler {
    protected Command getCommand() throws ExecutionException {
        CompoundCommand cmd = new CompoundCommand(Messages.CreateTickCommand_attachTick);
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            Object[] objectArray = structSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof OccurrenceSpecificationEditPartCN || object instanceof MessageOccurrenceSpecificationEditPartCN || object instanceof DestructionOccurrenceSpecificationEditPartCN) {
                    cmd.add(CreateTickCommand.attachTick((GraphicalEditPart)object));
                }
                ++n2;
            }
        }
        return cmd;
    }

    private static Command attachTick(final GraphicalEditPart osEditPart) {
        final IGraphicalEditPart tickContainer = TimeRulerUtils.findClosestTimeRuler((IGraphicalEditPart)osEditPart);
        if (tickContainer == null) {
            Activator.log.error("No tick container found", (Throwable)new Exception());
            return UnexecutableCommand.INSTANCE;
        }
        final View tickContainerView = (View)tickContainer.getModel();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)osEditPart.getEditingDomain());
        final Node osView = (Node)osEditPart.getModel();
        OccurrenceSpecification os = (OccurrenceSpecification)osView.getElement();
        if (TickUtils.containsTickFor(tickContainerView, os)) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand createTickCommand = new AbstractTransactionalCommand(editingDomain, Messages.CreateTickCommand_CreateTick, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                UMLViewProvider umlViewProvider = new UMLViewProvider();
                Node tickNode = umlViewProvider.createNode_26(null, tickContainerView, -1, true, osEditPart.getDiagramPreferencesHint());
                TickUtils.associateTickNodeToOccurrenceNode(tickNode, osView, false);
                tickContainer.refresh();
                ViewUtils.performEditRequest((View)tickNode, osEditPart.getViewer());
                return CommandResult.newOKCommandResult((Object)tickNode);
            }
        };
        return new ICommandProxy((ICommand)createTickCommand);
    }
}

