/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.LifelineUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.OccurrenceSpecificationUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateInvariantUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineTimelineCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullStateInvariantEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLViewProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.UMLFactory;

public class CutAndInsertOccurrenceSpecificationCommand
extends AbstractTransactionalCommand {
    private final FullStateInvariantEditPartCN fullStateInvariantEditPartCN;
    private final Point location;
    private final FullLifelineEditPartCN lifelineEditPart;
    private final Lifeline lifeline;
    private final boolean destruction;

    public CutAndInsertOccurrenceSpecificationCommand(FullStateInvariantEditPartCN fullStateInvariantEditPartCN, Point location, boolean destruction) {
        super(CutAndInsertOccurrenceSpecificationCommand.getEditingDomain(fullStateInvariantEditPartCN), Messages.CutAndInsertOccurrenceSpecificationCommand_CreateOccurrenceSpecification, null);
        this.fullStateInvariantEditPartCN = fullStateInvariantEditPartCN;
        this.location = location;
        this.destruction = destruction;
        this.lifelineEditPart = (FullLifelineEditPartCN)EditPartUtils.findParentEditPartWithId((EditPart)this.fullStateInvariantEditPartCN, 19);
        this.lifeline = (Lifeline)((View)this.lifelineEditPart.getModel()).getElement();
    }

    private static TransactionalEditingDomain getEditingDomain(FullStateInvariantEditPartCN fullStateInvariantEditPart) {
        StateInvariant stateInvariant = (StateInvariant)((View)fullStateInvariantEditPart.getModel()).getElement();
        return TransactionUtil.getEditingDomain((EObject)stateInvariant);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        final FullLifelineTimelineCompartmentEditPartCN timelineCompartmentEditPart = (FullLifelineTimelineCompartmentEditPartCN)EditPartUtils.findFirstChildEditPartWithId((EditPart)this.lifelineEditPart, 8);
        View timelineCompartmentView = (View)timelineCompartmentEditPart.getModel();
        View stateInvariantView = (View)this.fullStateInvariantEditPartCN.getModel();
        StateInvariant firstStateInvariant = (StateInvariant)stateInvariantView.getElement();
        int indexInFragments = this.lifeline.getInteraction().getFragments().indexOf((Object)firstStateInvariant);
        int indexInCoveredBys = this.lifeline.getCoveredBys().indexOf((Object)firstStateInvariant);
        int indexInCompartment = timelineCompartmentView.getChildren().indexOf((Object)stateInvariantView);
        DestructionOccurrenceSpecification newOccurrenceSpecification = this.destruction ? UMLFactory.eINSTANCE.createDestructionOccurrenceSpecification() : UMLFactory.eINSTANCE.createOccurrenceSpecification();
        OccurrenceSpecificationUtils.setAutogeneratedName((OccurrenceSpecification)newOccurrenceSpecification, true);
        this.lifeline.getInteraction().getFragments().add(indexInFragments + 1, (Object)newOccurrenceSpecification);
        this.lifeline.getCoveredBys().add(indexInCoveredBys + 1, (Object)newOccurrenceSpecification);
        UMLViewProvider umlViewProvider = new UMLViewProvider();
        final Node occurrenceSpecificationView = this.destruction ? umlViewProvider.createDestructionOccurrenceSpecification_27((EObject)newOccurrenceSpecification, timelineCompartmentView, indexInCompartment + 1, true, PreferencesHint.USE_DEFAULTS) : umlViewProvider.createOccurrenceSpecification_12((EObject)newOccurrenceSpecification, timelineCompartmentView, indexInCompartment + 1, true, PreferencesHint.USE_DEFAULTS);
        Location loc = NotationFactory.eINSTANCE.createLocation();
        Point pt = new Point(this.location);
        timelineCompartmentEditPart.getFigure().translateToRelative((Translatable)pt);
        pt.translate(timelineCompartmentEditPart.getFigure().getBounds().getTopLeft().getNegated());
        loc.setX(pt.x);
        loc.setY(pt.y);
        occurrenceSpecificationView.setLayoutConstraint((LayoutConstraint)loc);
        if (this.destruction) {
            OccurrenceSpecificationUtils.deleteEverythingAfter((OccurrenceSpecification)newOccurrenceSpecification, (View)occurrenceSpecificationView);
        } else {
            umlViewProvider.createNode_39(null, timelineCompartmentView, indexInCompartment + 2, true, PreferencesHint.USE_DEFAULTS);
            String id = StateInvariantUtils.getStateInvariantId(firstStateInvariant);
            StateInvariantUtils.createStateInvariant(id, this.lifelineEditPart, indexInFragments + 2, indexInCoveredBys + 2, indexInCompartment + 3);
        }
        LifelineUtils.updateFragmentNames(this.lifeline, (View)this.lifelineEditPart.getModel());
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                timelineCompartmentEditPart.refresh();
                ViewUtils.selectInViewer((View)occurrenceSpecificationView, CutAndInsertOccurrenceSpecificationCommand.this.lifelineEditPart.getViewer());
            }
        });
        return CommandResult.newOKCommandResult((Object)newOccurrenceSpecification);
    }
}

