/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.handlers.GraphicalCommandHandler;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForDo;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForUndo;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.CompactLifelineFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.FullLifelineFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.LifelineFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.CompactLifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.InteractionEditPartTN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.LifelineEditPart;

public class ToggleTimeRulerVisibility
extends GraphicalCommandHandler {
    protected Command getCommand() throws ExecutionException {
        CompoundCommand cmd = new CompoundCommand(Messages.ToggleTimeRulerVisibility_ToggleTimeRulerVisibility);
        List selectedElements = this.getSelectedElements();
        boolean first = true;
        InteractionEditPartTN interactionEditPart = null;
        for (IGraphicalEditPart selectedEditPart : selectedElements) {
            if (!(selectedEditPart instanceof FullLifelineEditPartCN) && !(selectedEditPart instanceof CompactLifelineEditPartCN)) continue;
            if (first && (interactionEditPart = (InteractionEditPartTN)EditPartUtils.findParentEditPartWithId((EditPart)selectedEditPart, 2)) != null) {
                cmd.add((Command)new RefreshCommandForUndo((GraphicalEditPart)interactionEditPart));
                first = false;
            }
            cmd.add(this.toggleTimeRulerVisibility(selectedEditPart));
        }
        if (interactionEditPart != null) {
            cmd.add((Command)new RefreshCommandForDo((GraphicalEditPart)interactionEditPart));
        }
        return cmd;
    }

    private Command toggleTimeRulerVisibility(final IGraphicalEditPart object) {
        return new ICommandProxy((ICommand)new AbstractTransactionalCommand(this.getEditingDomain(), Messages.ToggleTimeRulerVisibility_ToggleTimeRulerVisibility, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View timeRulerCompartmentView;
                LifelineEditPart lifelineEditPart = (LifelineEditPart)object;
                View lifelineView = (View)lifelineEditPart.getModel();
                timeRulerCompartmentView.setVisible(!(timeRulerCompartmentView = ViewUtils.findTimeRulerCompartmentView(lifelineView)).isVisible());
                return CommandResult.newOKCommandResult();
            }
        });
    }

    protected static final LifelineFigure getLifelineFigure(IFigure figure) {
        LifelineFigure result = null;
        result = FigureUtils.findChildFigureInstance(figure, FullLifelineFigure.class);
        if (result == null) {
            result = FigureUtils.findChildFigureInstance(figure, CompactLifelineFigure.class);
        }
        return result;
    }
}

