/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.Shape;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeTypes;
import org.eclipse.papyrus.uml.diagram.common.figure.edge.UMLEdgeFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractMessageFigure
extends UMLEdgeFigure {
    protected static final Font LABEL_FONT = new Font((Device)Display.getCurrent(), "SANS", 9, 0);
    private WrappingLabel messageLabel;

    public void paint(Graphics graphics) {
        graphics.setAntialias(1);
        super.paint(graphics);
    }

    public AbstractMessageFigure() {
        this.setForegroundColor(this.getForegroundColor());
        this.setSourceDecoration(this.createSourceDecoration());
        this.setTargetDecoration(this.createTargetDecoration());
    }

    protected RotatableDecoration createSourceDecoration() {
        return null;
    }

    protected RotatableDecoration createTargetDecoration() {
        return null;
    }

    protected void createContents() {
        super.createContents();
        this.messageLabel = new WrappingLabel();
        this.messageLabel.setText("");
        this.messageLabel.setFont(LABEL_FONT);
        this.add((IFigure)this.messageLabel);
    }

    public WrappingLabel getMessageLabel() {
        return this.messageLabel;
    }

    public void setLineWidth(int w) {
        super.setLineWidth(w);
        if (this.getSourceDecoration() instanceof Shape) {
            ((Shape)this.getSourceDecoration()).setLineWidth(w);
        }
        if (this.getTargetDecoration() instanceof Shape) {
            ((Shape)this.getTargetDecoration()).setLineWidth(w);
        }
    }

    public void setForegroundColor(Color c) {
        super.setForegroundColor(c);
        if (this.getSourceDecoration() instanceof Shape) {
            ((Shape)this.getSourceDecoration()).setForegroundColor(c);
            ((Shape)this.getSourceDecoration()).setBackgroundColor(c);
        }
        if (this.getTargetDecoration() instanceof Shape) {
            ((Shape)this.getTargetDecoration()).setForegroundColor(c);
            ((Shape)this.getTargetDecoration()).setBackgroundColor(c);
        }
    }

    protected static IMapMode getMapMode() {
        return MapModeTypes.IDENTITY_MM;
    }
}

