/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.CompactLifelineCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineTimelineCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditPartUtils {
    public static EditPart findFirstChildEditPartWithId(EditPart editPart, int visualId) {
        List<? extends EditPart> result = EditPartUtils.findChildEditPartsWithId(editPart, visualId);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public static List<? extends EditPart> findChildEditPartsWithId(EditPart editPart, int visualId) {
        ArrayList<EditPart> editParts = new ArrayList<EditPart>();
        EditPartUtils.internalFindChildEditPartsWithId(editPart, visualId, editParts);
        return editParts;
    }

    private static void internalFindChildEditPartsWithId(EditPart editPart, int visualId, List<EditPart> result) {
        View view;
        Object model = editPart.getModel();
        if (model instanceof View && UMLVisualIDRegistry.getVisualID(view = (View)model) == visualId) {
            result.add(editPart);
        }
        List children = editPart.getChildren();
        for (EditPart child : children) {
            EditPartUtils.internalFindChildEditPartsWithId(child, visualId, result);
        }
    }

    public static EditPart findParentEditPartWithId(EditPart editPart, int visualId) {
        EditPart parent = editPart;
        while (parent != null) {
            Object model = parent.getModel();
            if (!(model instanceof View)) break;
            View parentView = (View)model;
            if (UMLVisualIDRegistry.getVisualID(parentView) == visualId) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static GraphicalEditPart findEditPartClosestToOrdinate(int ordinate, List<? extends GraphicalEditPart> editParts) {
        if (editParts.isEmpty()) {
            return null;
        }
        TreeMap<Integer, GraphicalEditPart> distanceMap = new TreeMap<Integer, GraphicalEditPart>();
        for (GraphicalEditPart graphicalEditPart : editParts) {
            IFigure figure = graphicalEditPart.getFigure();
            Rectangle bounds = new Rectangle(figure.getBounds());
            figure.getParent().translateToAbsolute((Translatable)bounds);
            int posY = bounds.y + bounds.height / 2;
            int distance = Math.abs(posY - ordinate);
            distanceMap.put(distance, graphicalEditPart);
        }
        return (GraphicalEditPart)distanceMap.values().iterator().next();
    }

    public static boolean isEditPartFor(EditPart editPart, EClass ... eClasses) {
        Object model = editPart.getModel();
        if (model instanceof View) {
            View view = (View)model;
            return ViewUtils.isViewFor(view, eClasses);
        }
        return false;
    }

    public static CompartmentEditPart findParentTimelineCompartment(EditPart editPart) {
        ShapeCompartmentEditPart compartmentEditPart = (FullLifelineTimelineCompartmentEditPartCN)EditPartUtils.findParentEditPartWithId(editPart, 8);
        if (compartmentEditPart == null) {
            compartmentEditPart = (CompactLifelineCompartmentEditPartCN)EditPartUtils.findParentEditPartWithId(editPart, 23);
        }
        return compartmentEditPart;
    }

    public static void revealEditPart(EditPart editPart) {
        if (editPart != null && editPart.getViewer() != null) {
            editPart.getViewer().reveal(editPart);
        }
    }
}

