/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FigureUtils {
    private FigureUtils() {
    }

    public static <T extends IFigure> T findChildFigureInstance(IFigure parent, Class<T> childFigureClass) {
        List children = parent.getChildren();
        for (IFigure child : children) {
            if (childFigureClass.isAssignableFrom(child.getClass())) {
                return (T)child;
            }
            T subresult = FigureUtils.findChildFigureInstance(child, childFigureClass);
            if (subresult == null) continue;
            return subresult;
        }
        return null;
    }

    public static <T extends IFigure> List<T> findChildFigureInstances(IFigure parent, Class<T> childFigureClass) {
        ArrayList result = new ArrayList();
        FigureUtils.internalFindChildFigureInstances(parent, result, childFigureClass);
        return result;
    }

    public static <T extends IFigure> void internalFindChildFigureInstances(IFigure parent, List<T> result, Class<T> childFigureClass) {
        List children = parent.getChildren();
        for (IFigure child : children) {
            if (childFigureClass.isAssignableFrom(child.getClass())) {
                result.add(child);
                continue;
            }
            FigureUtils.internalFindChildFigureInstances(child, result, childFigureClass);
        }
    }

    public static <T extends IFigure> T findParentFigureInstance(IFigure figure, Class<T> parentFigureClass) {
        IFigure parent = figure.getParent();
        while (parent != null) {
            if (parentFigureClass.isAssignableFrom(parent.getClass())) {
                return (T)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static Rectangle constrainBoundsWithinContainingCompartment(Rectangle bounds, IFigure figure) {
        Rectangle result = new Rectangle(bounds);
        ResizableCompartmentFigure parentCompartment = FigureUtils.findParentFigureInstance(figure, ResizableCompartmentFigure.class);
        if (parentCompartment == null) {
            return result;
        }
        Rectangle parentBounds = parentCompartment.getBounds();
        result.x = Math.max(result.x, 0);
        result.y = Math.max(result.y, 0);
        result.x = Math.min(result.x, parentBounds.width - result.width);
        result.y = Math.min(result.y, parentBounds.height - result.height);
        return result;
    }

    public static Point getLayeredPaneOrigin(IFigure figure) {
        LayeredPane layeredPane = FigureUtils.findChildFigureInstance(FigureUtilities.getRoot((IFigure)figure), LayeredPane.class);
        Point origin = new Point(0, 0);
        layeredPane.translateToRelative((Translatable)origin);
        return origin;
    }

    public static double getScale(IFigure figure) {
        ScalableFigure scalableFigure = FigureUtils.findParentFigureInstance(figure, ScalableFigure.class);
        return scalableFigure.getScale();
    }

    public static Point scaleByZoom(Point delta, IFigure figure) {
        return new Point(delta).scale(1.0 / FigureUtils.getScale(figure));
    }
}

