/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.part;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLDiagramUpdater;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLLinkDescriptor;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLNodeDescriptor;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.Package;

public class UMLDiagramContentInitializer {
    private final Map myDomain2NotationMap = new HashMap();
    private final Collection myLinkDescriptors = new LinkedList();

    public void initDiagramContent(Diagram diagram) {
        if (!"PapyrusUMLTimingDiagram".equals(diagram.getType())) {
            UMLDiagramEditorPlugin.getInstance().logError("Incorrect diagram passed as a parameter: " + diagram.getType());
            return;
        }
        if (!(diagram.getElement() instanceof Package)) {
            UMLDiagramEditorPlugin.getInstance().logError("Incorrect diagram element specified: " + diagram.getElement() + " instead of Package");
            return;
        }
        this.createPackage_1Children((View)diagram);
        this.createLinks(diagram);
    }

    private void createPackage_1Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getPackage_1SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createInteraction_2Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getInteraction_2OutgoingLinks(view));
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getInteraction_2SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
        this.createInteractionInteractionCompartment_5Children((View)this.getCompartment(view, 5));
        this.createInteractionTimeRulerCompartment_29Children((View)this.getCompartment(view, 29));
    }

    private void createLifeline_19Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getLifeline_19OutgoingLinks(view));
        this.createLifelineFullLifelineStateDefinitionCompartment_7Children((View)this.getCompartment(view, 7));
        this.createLifelineFullLifelineTimelineCompartment_8Children((View)this.getCompartment(view, 8));
        this.createLifelineFullLifelineTimeRuler_82Children((View)this.getCompartment(view, 82));
    }

    private void createLifeline_20Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getLifeline_20OutgoingLinks(view));
        this.createLifelineCompactLifelineCompartment_23Children((View)this.getCompartment(view, 23));
        this.createLifelineCompactLifelineTimeRuler_83Children((View)this.getCompartment(view, 83));
    }

    private void createStateInvariant_11Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getStateInvariant_11OutgoingLinks(view));
    }

    private void createStateInvariant_28Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getStateInvariant_28OutgoingLinks(view));
    }

    private void createOccurrenceSpecification_12Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getOccurrenceSpecification_12OutgoingLinks(view));
    }

    private void createMessageOccurrenceSpecification_13Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getMessageOccurrenceSpecification_13OutgoingLinks(view));
    }

    private void createTimeConstraint_15Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getTimeConstraint_15OutgoingLinks(view));
    }

    private void createTimeObservation_16Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getTimeObservation_16OutgoingLinks(view));
    }

    private void createDurationConstraint_18Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getDurationConstraint_18OutgoingLinks(view));
    }

    private void createDurationObservation_17Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getDurationObservation_17OutgoingLinks(view));
    }

    private void createGeneralOrdering_67Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getGeneralOrdering_67OutgoingLinks(view));
    }

    private void createDestructionOccurrenceSpecification_27Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getDestructionOccurrenceSpecification_27OutgoingLinks(view));
    }

    private void createLifeline_40Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getLifeline_40OutgoingLinks(view));
    }

    private void createGate_69Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getGate_69OutgoingLinks(view));
    }

    private void createInteractionInteractionCompartment_5Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getInteractionInteractionCompartment_5SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createLifelineFullLifelineStateDefinitionCompartment_7Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getLifelineFullLifelineStateDefinitionCompartment_7SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createLifelineFullLifelineTimelineCompartment_8Children(View view) {
        List childNodeDescriptors = UMLDiagramUpdater.getLifelineFullLifelineTimelineCompartment_8SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createLifelineCompactLifelineCompartment_23Children(View view) {
        List childNodeDescriptors = UMLDiagramUpdater.getLifelineCompactLifelineCompartment_23SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createInteractionTimeRulerCompartment_29Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getInteractionTimeRulerCompartment_29SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createLifelineFullLifelineTimeRuler_82Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getLifelineFullLifelineTimeRuler_82SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createLifelineCompactLifelineTimeRuler_83Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getLifelineCompactLifelineTimeRuler_83SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createNode(View parentView, UMLNodeDescriptor nodeDescriptor) {
        String nodeType = UMLVisualIDRegistry.getType(nodeDescriptor.getVisualID());
        Node node = ViewService.createNode((View)parentView, (EObject)nodeDescriptor.getModelElement(), (String)nodeType, (PreferencesHint)UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        switch (nodeDescriptor.getVisualID()) {
            case 2: {
                this.createInteraction_2Children((View)node);
                return;
            }
            case 19: {
                this.createLifeline_19Children((View)node);
                return;
            }
            case 20: {
                this.createLifeline_20Children((View)node);
                return;
            }
            case 11: {
                this.createStateInvariant_11Children((View)node);
                return;
            }
            case 28: {
                this.createStateInvariant_28Children((View)node);
                return;
            }
            case 12: {
                this.createOccurrenceSpecification_12Children((View)node);
                return;
            }
            case 13: {
                this.createMessageOccurrenceSpecification_13Children((View)node);
                return;
            }
            case 15: {
                this.createTimeConstraint_15Children((View)node);
                return;
            }
            case 16: {
                this.createTimeObservation_16Children((View)node);
                return;
            }
            case 18: {
                this.createDurationConstraint_18Children((View)node);
                return;
            }
            case 17: {
                this.createDurationObservation_17Children((View)node);
                return;
            }
            case 67: {
                this.createGeneralOrdering_67Children((View)node);
                return;
            }
            case 27: {
                this.createDestructionOccurrenceSpecification_27Children((View)node);
                return;
            }
            case 40: {
                this.createLifeline_40Children((View)node);
                return;
            }
            case 69: {
                this.createGate_69Children((View)node);
                return;
            }
        }
    }

    private void createLinks(Diagram diagram) {
        boolean continueLinkCreation = true;
        while (continueLinkCreation) {
            continueLinkCreation = false;
            LinkedList<UMLLinkDescriptor> additionalDescriptors = new LinkedList<UMLLinkDescriptor>();
            Iterator it = this.myLinkDescriptors.iterator();
            while (it.hasNext()) {
                UMLLinkDescriptor nextLinkDescriptor = (UMLLinkDescriptor)((Object)it.next());
                if (!this.myDomain2NotationMap.containsKey(nextLinkDescriptor.getSource()) || !this.myDomain2NotationMap.containsKey(nextLinkDescriptor.getDestination())) continue;
                String linkType = UMLVisualIDRegistry.getType(nextLinkDescriptor.getVisualID());
                Edge edge = ViewService.getInstance().createEdge(nextLinkDescriptor.getSemanticAdapter(), (View)diagram, linkType, -1, true, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (edge == null) continue;
                edge.setSource((View)this.myDomain2NotationMap.get(nextLinkDescriptor.getSource()));
                edge.setTarget((View)this.myDomain2NotationMap.get(nextLinkDescriptor.getDestination()));
                it.remove();
                if (nextLinkDescriptor.getModelElement() != null) {
                    this.myDomain2NotationMap.put(nextLinkDescriptor.getModelElement(), edge);
                }
                continueLinkCreation = true;
                switch (nextLinkDescriptor.getVisualID()) {
                    case 3: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getMessage_3OutgoingLinks((View)edge));
                        break;
                    }
                    case 4: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getMessage_4OutgoingLinks((View)edge));
                        break;
                    }
                    case 41: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getMessage_41OutgoingLinks((View)edge));
                        break;
                    }
                    case 44: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getMessage_44OutgoingLinks((View)edge));
                        break;
                    }
                    case 47: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getMessage_47OutgoingLinks((View)edge));
                        break;
                    }
                    case 50: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getMessage_50OutgoingLinks((View)edge));
                        break;
                    }
                    case 53: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getMessage_53OutgoingLinks((View)edge));
                    }
                }
            }
            this.myLinkDescriptors.addAll(additionalDescriptors);
        }
    }

    private Node getCompartment(View node, int visualID) {
        String type = UMLVisualIDRegistry.getType(visualID);
        for (View nextView : node.getChildren()) {
            if (!(nextView instanceof Node) || !type.equals(nextView.getType())) continue;
            return (Node)nextView;
        }
        return null;
    }
}

