/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.providers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.infra.extendedtypes.types.IExtendedHintedElementType;
import org.eclipse.papyrus.infra.extendedtypes.util.ElementTypeUtils;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.PreferenceConstantHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLElementTypes;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class UMLViewProvider
extends AbstractProvider
implements IViewProvider {
    public final boolean provides(IOperation operation) {
        if (operation instanceof CreateViewForKindOperation) {
            return this.provides((CreateViewForKindOperation)operation);
        }
        assert (operation instanceof CreateViewOperation);
        if (operation instanceof CreateDiagramViewOperation) {
            return this.provides((CreateDiagramViewOperation)operation);
        }
        if (operation instanceof CreateEdgeViewOperation) {
            return this.provides((CreateEdgeViewOperation)operation);
        }
        if (operation instanceof CreateNodeViewOperation) {
            return this.provides((CreateNodeViewOperation)operation);
        }
        return false;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        String modelID = UMLVisualIDRegistry.getModelID(op.getContainerView());
        if (!this.getDiagramProvidedId().equals(modelID)) {
            return false;
        }
        int visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
        if (Node.class.isAssignableFrom(op.getViewKind())) {
            return UMLVisualIDRegistry.canCreateNode(op.getContainerView(), visualID);
        }
        return true;
    }

    protected String getDiagramProvidedId() {
        return "PapyrusUMLTimingDiagram";
    }

    protected boolean provides(CreateDiagramViewOperation op) {
        return "PapyrusUMLTimingDiagram".equals(op.getSemanticHint()) && UMLVisualIDRegistry.getDiagramVisualID(this.getSemanticElement(op.getSemanticAdapter())) != -1;
    }

    protected boolean provides(CreateNodeViewOperation op) {
        int visualID;
        if (op.getContainerView() == null) {
            return false;
        }
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        if (op.getSemanticHint() == null) {
            if (elementType != null || domainElement == null) {
                return false;
            }
            visualID = UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement);
        } else {
            visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
            if (elementType != null) {
                IElementType closestNonExtendedType;
                if (elementType instanceof IExtendedHintedElementType ? !UMLElementTypes.isKnownElementType(closestNonExtendedType = ElementTypeUtils.getClosestDiagramType((IElementType)elementType)) || !(closestNonExtendedType instanceof IHintedType) : !UMLElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return false;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!op.getSemanticHint().equals(elementTypeHint)) {
                    return false;
                }
                if (domainElement != null && visualID != UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) {
                    return false;
                }
            } else {
                if (!"PapyrusUMLTimingDiagram".equals(UMLVisualIDRegistry.getModelID(op.getContainerView()))) {
                    return false;
                }
                switch (visualID) {
                    case 9: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 39: {
                        break;
                    }
                    case 2: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 27: 
                    case 28: 
                    case 40: 
                    case 67: 
                    case 69: {
                        if (domainElement != null && visualID == UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return 2 == visualID || 19 == visualID || 20 == visualID || 11 == visualID || 28 == visualID || 12 == visualID || 13 == visualID || 9 == visualID || 39 == visualID || 15 == visualID || 16 == visualID || 18 == visualID || 17 == visualID || 67 == visualID || 24 == visualID || 25 == visualID || 26 == visualID || 27 == visualID || 40 == visualID || 69 == visualID;
    }

    protected boolean provides(CreateEdgeViewOperation op) {
        IElementType closestNonExtendedType;
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (elementType instanceof IExtendedHintedElementType ? !UMLElementTypes.isKnownElementType(closestNonExtendedType = ElementTypeUtils.getClosestDiagramType((IElementType)elementType)) || !(closestNonExtendedType instanceof IHintedType) : !UMLElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
            return false;
        }
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        if (elementTypeHint == null || op.getSemanticHint() != null && !elementTypeHint.equals(op.getSemanticHint())) {
            return false;
        }
        int visualID = UMLVisualIDRegistry.getVisualID(elementTypeHint);
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        return domainElement == null || visualID == UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    public Diagram createDiagram(IAdaptable semanticAdapter, String diagramKind, PreferencesHint preferencesHint) {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        diagram.getStyles().add((Object)NotationFactory.eINSTANCE.createDiagramStyle());
        diagram.setType("PapyrusUMLTimingDiagram");
        diagram.setElement(this.getSemanticElement(semanticAdapter));
        diagram.setMeasurementUnit(MeasurementUnit.PIXEL_LITERAL);
        return diagram;
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        int visualID = semanticHint == null ? UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement) : UMLVisualIDRegistry.getVisualID(semanticHint);
        switch (visualID) {
            case 2: {
                return this.createInteraction_2(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 19: {
                return this.createLifeline_19(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 20: {
                return this.createLifeline_20(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 11: {
                return this.createStateInvariant_11(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 28: {
                return this.createStateInvariant_28(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 12: {
                return this.createOccurrenceSpecification_12(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 13: {
                return this.createMessageOccurrenceSpecification_13(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 9: {
                return this.createNode_9(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 39: {
                return this.createNode_39(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 15: {
                return this.createTimeConstraint_15(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 16: {
                return this.createTimeObservation_16(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 18: {
                return this.createDurationConstraint_18(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 17: {
                return this.createDurationObservation_17(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 67: {
                return this.createGeneralOrdering_67(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 24: {
                return this.createNode_24(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 25: {
                return this.createNode_25(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 26: {
                return this.createNode_26(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 27: {
                return this.createDestructionOccurrenceSpecification_27(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 40: {
                return this.createLifeline_40(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 69: {
                return this.createGate_69(domainElement, containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        switch (UMLVisualIDRegistry.getVisualID(elementTypeHint)) {
            case 3: {
                return this.createMessage_3(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4: {
                return this.createMessage_4(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 41: {
                return this.createMessage_41(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 44: {
                return this.createMessage_44(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 47: {
                return this.createMessage_47(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 50: {
                return this.createMessage_50(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 53: {
                return this.createMessage_53(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Node createInteraction_2(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interaction");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interaction");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interaction");
        Node label37 = this.createLabel((View)node, UMLVisualIDRegistry.getType(37));
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(5), false, false, true, true);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(29), false, false, true, true);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interaction");
        return node;
    }

    public Node createLifeline_19(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(19));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FullLifeline");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FullLifeline");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FullLifeline");
        Node label21 = this.createLabel((View)node, UMLVisualIDRegistry.getType(21));
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7), false, false, true, true);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(8), false, false, false, false);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(82), false, false, true, true);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FullLifeline");
        return node;
    }

    public Node createLifeline_20(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(20));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CompactLifeline");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CompactLifeline");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CompactLifeline");
        Node label22 = this.createLabel((View)node, UMLVisualIDRegistry.getType(22));
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(23), false, false, false, false);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(83), false, false, true, true);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CompactLifeline");
        return node;
    }

    public Node createStateInvariant_11(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(11));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FullStateInvariant");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FullStateInvariant");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FullStateInvariant");
        Node label62 = this.createLabel((View)node, UMLVisualIDRegistry.getType(62));
        label62.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location62 = (Location)label62.getLayoutConstraint();
        location62.setX(0);
        location62.setY(5);
        return node;
    }

    public Node createStateInvariant_28(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(28));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CompactStateInvariant");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CompactStateInvariant");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CompactStateInvariant");
        Node label31 = this.createLabel((View)node, UMLVisualIDRegistry.getType(31));
        Node label64 = this.createLabel((View)node, UMLVisualIDRegistry.getType(64));
        label64.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location64 = (Location)label64.getLayoutConstraint();
        location64.setX(0);
        location64.setY(5);
        return node;
    }

    public Node createOccurrenceSpecification_12(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(12));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"OccurrenceSpecification");
        Node label10 = this.createLabel((View)node, UMLVisualIDRegistry.getType(10));
        label10.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location10 = (Location)label10.getLayoutConstraint();
        location10.setX(0);
        location10.setY(18);
        Node label58 = this.createLabel((View)node, UMLVisualIDRegistry.getType(58));
        label58.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location58 = (Location)label58.getLayoutConstraint();
        location58.setX(0);
        location58.setY(5);
        return node;
    }

    public Node createMessageOccurrenceSpecification_13(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(13));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"MessageOccurrenceSpecification");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"MessageOccurrenceSpecification");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"MessageOccurrenceSpecification");
        Node label14 = this.createLabel((View)node, UMLVisualIDRegistry.getType(14));
        label14.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location14 = (Location)label14.getLayoutConstraint();
        location14.setX(0);
        location14.setY(18);
        Node label59 = this.createLabel((View)node, UMLVisualIDRegistry.getType(59));
        label59.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location59 = (Location)label59.getLayoutConstraint();
        location59.setX(0);
        location59.setY(5);
        return node;
    }

    public Node createNode_9(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(9));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StateDefinition");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StateDefinition");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StateDefinition");
        Node label38 = this.createLabel((View)node, UMLVisualIDRegistry.getType(38));
        label38.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        return node;
    }

    public Node createNode_39(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(39));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"VerticalLineStateInvariant");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"VerticalLineStateInvariant");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"VerticalLineStateInvariant");
        return node;
    }

    public Node createTimeConstraint_15(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(15));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeConstraint");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeConstraint");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeConstraint");
        Node label30 = this.createLabel((View)node, UMLVisualIDRegistry.getType(30));
        label30.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location30 = (Location)label30.getLayoutConstraint();
        location30.setX(-5);
        location30.setY(-15);
        Node label65 = this.createLabel((View)node, UMLVisualIDRegistry.getType(65));
        label65.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location65 = (Location)label65.getLayoutConstraint();
        location65.setX(0);
        location65.setY(5);
        return node;
    }

    public Node createTimeObservation_16(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(16));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeObservation");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeObservation");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeObservation");
        Node label34 = this.createLabel((View)node, UMLVisualIDRegistry.getType(34));
        label34.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location34 = (Location)label34.getLayoutConstraint();
        location34.setX(-5);
        location34.setY(-15);
        Node label66 = this.createLabel((View)node, UMLVisualIDRegistry.getType(66));
        label66.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location66 = (Location)label66.getLayoutConstraint();
        location66.setX(0);
        location66.setY(5);
        return node;
    }

    public Node createDurationConstraint_18(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(18));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DurationConstraint");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DurationConstraint");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DurationConstraint");
        Node label33 = this.createLabel((View)node, UMLVisualIDRegistry.getType(33));
        label33.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location33 = (Location)label33.getLayoutConstraint();
        location33.setX(0);
        location33.setY(15);
        return node;
    }

    public Node createDurationObservation_17(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(17));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DurationObservation");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DurationObservation");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DurationObservation");
        Node label35 = this.createLabel((View)node, UMLVisualIDRegistry.getType(35));
        label35.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location35 = (Location)label35.getLayoutConstraint();
        location35.setX(0);
        location35.setY(15);
        return node;
    }

    public Node createGeneralOrdering_67(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(67));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"GeneralOrdering");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"GeneralOrdering");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"GeneralOrdering");
        Node label68 = this.createLabel((View)node, UMLVisualIDRegistry.getType(68));
        label68.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location68 = (Location)label68.getLayoutConstraint();
        location68.setX(-5);
        location68.setY(-15);
        return node;
    }

    public Node createNode_24(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(24));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FreeTimingRuler");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FreeTimingRuler");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FreeTimingRuler");
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(80), false, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FreeTimingRuler");
        return node;
    }

    public Node createNode_25(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(25));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"LinearTimingRuler");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"LinearTimingRuler");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"LinearTimingRuler");
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(81), false, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"LinearTimingRuler");
        return node;
    }

    public Node createNode_26(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(26));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Tick");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Tick");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Tick");
        Node label36 = this.createLabel((View)node, UMLVisualIDRegistry.getType(36));
        label36.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        label36.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location36 = (Location)label36.getLayoutConstraint();
        location36.setX(0);
        location36.setY(12);
        return node;
    }

    public Node createDestructionOccurrenceSpecification_27(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(27));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DestructionOccurrenceSpecification");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DestructionOccurrenceSpecification");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DestructionOccurrenceSpecification");
        Node label32 = this.createLabel((View)node, UMLVisualIDRegistry.getType(32));
        label32.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location32 = (Location)label32.getLayoutConstraint();
        location32.setX(0);
        location32.setY(18);
        Node label63 = this.createLabel((View)node, UMLVisualIDRegistry.getType(63));
        label63.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location63 = (Location)label63.getLayoutConstraint();
        location63.setX(0);
        location63.setY(5);
        return node;
    }

    public Node createLifeline_40(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(40));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Lifeline");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Lifeline");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Lifeline");
        return node;
    }

    public Node createGate_69(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(69));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Gate");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Gate");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Gate");
        Node label70 = this.createLabel((View)node, UMLVisualIDRegistry.getType(70));
        label70.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location70 = (Location)label70.getLayoutConstraint();
        location70.setX(20);
        location70.setY(0);
        return node;
    }

    public Edge createMessage_3(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(3));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageSync");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageSync");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageSync");
        Node label56 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(56));
        label56.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location56 = (Location)label56.getLayoutConstraint();
        location56.setX(0);
        location56.setY(-10);
        Node label57 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(57));
        label57.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location57 = (Location)label57.getLayoutConstraint();
        location57.setX(0);
        location57.setY(-30);
        return edge;
    }

    public Edge createMessage_4(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageAsync");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageAsync");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageAsync");
        Node label60 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(60));
        label60.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location60 = (Location)label60.getLayoutConstraint();
        location60.setX(0);
        location60.setY(-10);
        Node label61 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(61));
        label61.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location61 = (Location)label61.getLayoutConstraint();
        location61.setX(0);
        location61.setY(-30);
        return edge;
    }

    public Edge createMessage_41(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(41));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageReply");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageReply");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageReply");
        Node label42 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(42));
        label42.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location42 = (Location)label42.getLayoutConstraint();
        location42.setX(0);
        location42.setY(-10);
        Node label43 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(43));
        label43.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location43 = (Location)label43.getLayoutConstraint();
        location43.setX(0);
        location43.setY(-30);
        return edge;
    }

    public Edge createMessage_44(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(44));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageCreate");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageCreate");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageCreate");
        Node label45 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(45));
        label45.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location45 = (Location)label45.getLayoutConstraint();
        location45.setX(0);
        location45.setY(-10);
        Node label46 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(46));
        label46.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location46 = (Location)label46.getLayoutConstraint();
        location46.setX(0);
        location46.setY(-30);
        return edge;
    }

    public Edge createMessage_47(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(47));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageDelete");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageDelete");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageDelete");
        Node label48 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(48));
        label48.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location48 = (Location)label48.getLayoutConstraint();
        location48.setX(0);
        location48.setY(-10);
        Node label49 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(49));
        label49.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location49 = (Location)label49.getLayoutConstraint();
        location49.setX(0);
        location49.setY(-30);
        return edge;
    }

    public Edge createMessage_50(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(50));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageLost");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageLost");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageLost");
        Node label51 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(51));
        label51.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location51 = (Location)label51.getLayoutConstraint();
        location51.setX(0);
        location51.setY(-10);
        Node label52 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(52));
        label52.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location52 = (Location)label52.getLayoutConstraint();
        location52.setX(0);
        location52.setY(-30);
        return edge;
    }

    public Edge createMessage_53(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(53));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageFound");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageFound");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"MessageFound");
        Node label54 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(54));
        label54.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location54 = (Location)label54.getLayoutConstraint();
        location54.setX(0);
        location54.setY(-10);
        Node label55 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(55));
        label55.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location55 = (Location)label55.getLayoutConstraint();
        location55.setX(0);
        location55.setY(-30);
        return edge;
    }

    protected void stampShortcut(View containerView, Node target) {
        if (!"PapyrusUMLTimingDiagram".equals(UMLVisualIDRegistry.getModelID(containerView))) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"PapyrusUMLTimingDiagram");
            target.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }

    protected Node createLabel(View owner, String hint) {
        DecorationNode rv = NotationFactory.eINSTANCE.createDecorationNode();
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected Node createCompartment(View owner, String hint, boolean canCollapse, boolean hasTitle, boolean canSort, boolean canFilter) {
        Object rv = canCollapse ? NotationFactory.eINSTANCE.createBasicCompartment() : NotationFactory.eINSTANCE.createDecorationNode();
        rv.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        if (hasTitle) {
            TitleStyle ts = NotationFactory.eINSTANCE.createTitleStyle();
            ts.setShowTitle(true);
            rv.getStyles().add((Object)ts);
        }
        if (canSort) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createSortingStyle());
        }
        if (canFilter) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createFilteringStyle());
        }
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected EObject getSemanticElement(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)eObject), (EObject)eObject);
        }
        return null;
    }

    protected IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }

    private void initFontStyleFromPrefs(View view, IPreferenceStore store, String elementName) {
        String fontConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)1);
        String fontColorConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)2);
        FontStyle viewFontStyle = (FontStyle)view.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (viewFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)store, (String)fontConstant);
            viewFontStyle.setFontName(fontData.getName());
            viewFontStyle.setFontHeight(fontData.getHeight());
            viewFontStyle.setBold((fontData.getStyle() & 1) != 0);
            viewFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)fontColorConstant);
            viewFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
    }

    private void initForegroundFromPrefs(View view, IPreferenceStore store, String elementName) {
        String lineColorConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)3);
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)lineColorConstant);
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
    }

    private void initBackgroundFromPrefs(View view, IPreferenceStore store, String elementName) {
        String fillColorConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)0);
        String gradientColorConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)4);
        String gradientPolicyConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)5);
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)fillColorConstant);
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        FillStyle fillStyle = (FillStyle)view.getStyle(NotationPackage.Literals.FILL_STYLE);
        fillStyle.setFillColor(FigureUtilities.RGBToInteger((RGB)fillRGB).intValue());
        if (store.getBoolean(gradientPolicyConstant)) {
            GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(store.getString(gradientColorConstant));
            fillStyle.setGradient(gradientPreferenceConverter.getGradientData());
            fillStyle.setTransparency(gradientPreferenceConverter.getTransparency());
        }
    }
}

