/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.databinding;

import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class AnnotationObservableValue
extends AbstractObservableValue {
    protected EModelElement source;
    protected EditingDomain domain;
    protected String annotationName;
    protected String key;
    protected boolean deleteWithLastEntry;

    public AnnotationObservableValue(EModelElement source, EditingDomain domain, String annotationName, String key) {
        this(source, domain, annotationName, key, false);
    }

    public AnnotationObservableValue(EModelElement source, EditingDomain domain, String annotationName, String key, boolean deleteWithLastEntry) {
        this.source = source;
        this.domain = domain;
        this.annotationName = annotationName;
        this.key = key;
        this.deleteWithLastEntry = deleteWithLastEntry;
    }

    public Object getValueType() {
        return String.class;
    }

    protected Object doGetValue() {
        EAnnotation annotation = this.getEAnnotation();
        if (annotation == null) {
            return null;
        }
        return annotation.getDetails().get((Object)this.key);
    }

    protected EAnnotation getEAnnotation() {
        return this.source.getEAnnotation(this.annotationName);
    }

    protected void doSetValue(Object value) {
        Command emfCommand = this.getCommand(value);
        if (emfCommand != null) {
            this.domain.getCommandStack().execute(emfCommand);
        }
    }

    protected Command getCommand(Object value) {
        EAnnotation annotation = this.getEAnnotation();
        if (value == null ? annotation == null || !annotation.getDetails().containsKey((Object)this.key) : !(value instanceof String)) {
            return null;
        }
        CompoundCommand emfCommand = new CompoundCommand("Set " + this.key){

            public boolean prepare() {
                if (this.isEmpty()) {
                    return false;
                }
                return ((Command)this.commandList.get(0)).canExecute();
            }
        };
        if (annotation == null) {
            annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            SetCommand attachToSourceCommand = new SetCommand(this.domain, (EObject)annotation, (EStructuralFeature)EcorePackage.eINSTANCE.getEAnnotation_EModelElement(), (Object)this.source);
            attachToSourceCommand.setLabel("Attach to source");
            emfCommand.append((Command)attachToSourceCommand);
            SetCommand nameCommand = new SetCommand(this.domain, (EObject)annotation, (EStructuralFeature)EcorePackage.eINSTANCE.getEAnnotation_Source(), (Object)this.annotationName);
            nameCommand.setLabel("Set name");
            emfCommand.append((Command)nameCommand);
        }
        if (value == null) {
            if (annotation.getDetails().size() == 1 && annotation.getDetails().containsKey((Object)this.key) && this.deleteWithLastEntry) {
                SetCommand deleteAnnotationCommand = new SetCommand(this.domain, (EObject)annotation, (EStructuralFeature)EcorePackage.eINSTANCE.getEAnnotation_EModelElement(), null);
                deleteAnnotationCommand.setLabel("Delete EAnnotation");
                emfCommand.append((Command)deleteAnnotationCommand);
            } else {
                RemoveEntryCommand removeEntryCommand = new RemoveEntryCommand(annotation, this.key);
                emfCommand.append((Command)removeEntryCommand);
            }
        } else {
            AddEntryCommand addEntryCommand = new AddEntryCommand(annotation, this.key, (String)value);
            emfCommand.append((Command)addEntryCommand);
        }
        return emfCommand;
    }

    protected class AddEntryCommand
    extends AbstractCommand {
        private EAnnotation annotation;
        private String key;
        private String value;

        public AddEntryCommand(EAnnotation annotation, String key, String value) {
            this.annotation = annotation;
            this.key = key;
            this.value = value;
        }

        public void execute() {
            this.annotation.getDetails().put((Object)this.key, (Object)this.value);
        }

        public void redo() {
            this.execute();
        }

        public void undo() {
            this.annotation.getDetails().remove((Object)this.key);
        }

        public boolean prepare() {
            return true;
        }
    }

    protected class RemoveEntryCommand
    extends AbstractCommand {
        private EAnnotation annotation;
        private String key;
        private String previousValue;
        private boolean undo = false;

        public RemoveEntryCommand(EAnnotation annotation, String key) {
            this.annotation = annotation;
            this.key = key;
        }

        public void execute() {
            this.undo = this.annotation.getDetails().containsKey((Object)this.key);
            if (this.undo) {
                this.previousValue = (String)this.annotation.getDetails().get((Object)this.key);
                this.annotation.getDetails().remove((Object)this.key);
            }
        }

        public void redo() {
            this.execute();
        }

        public boolean prepare() {
            return true;
        }

        public void undo() {
            if (this.undo) {
                this.annotation.getDetails().put((Object)this.key, (Object)this.previousValue);
            }
        }
    }
}

