/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramDragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.CommandProxyWithResult;
import org.eclipse.papyrus.uml.diagram.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.uml.diagram.common.commands.DeferredCreateCommand;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.util.ViewServiceUtil;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonDiagramDragDropEditPolicy
extends DiagramDragDropEditPolicy {
    private Set<Integer> specificDrop = null;
    protected ILinkMappingHelper linkmappingHelper;

    public CommonDiagramDragDropEditPolicy(ILinkMappingHelper mappingHelper) {
        this.linkmappingHelper = mappingHelper;
    }

    protected Set<Integer> getSpecificDrop() {
        if (this.specificDrop == null) {
            this.specificDrop = this.getDroppableElementVisualId();
        }
        return this.specificDrop;
    }

    public abstract IElementType getUMLElementType(int var1);

    public abstract int getNodeVisualID(View var1, EObject var2);

    public abstract int getLinkWithClassVisualID(EObject var1);

    protected abstract Set<Integer> getDroppableElementVisualId();

    protected Command createViewsAndArrangeCommand(DropObjectsRequest dropRequest, List viewDescriptors) {
        CreateViewRequest createViewRequest = new CreateViewRequest(viewDescriptors);
        createViewRequest.setLocation(dropRequest.getLocation());
        Command createCommand = this.getHost().getCommand((Request)createViewRequest);
        return createCommand;
    }

    public CompositeCommand dropBinaryLink(CompositeCommand cc, Element source, Element target, int linkVISUALID, Point absoluteLocation, Element semanticLink) {
        ICommand createCommand;
        GraphicalEditPart sourceEditPart = (GraphicalEditPart)this.lookForEditPart((EObject)source);
        GraphicalEditPart targetEditPart = (GraphicalEditPart)this.lookForEditPart((EObject)target);
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)this.getUMLElementType(linkVISUALID), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), this.getDiagramPreferencesHint());
        SemanticAdapter sourceAdapter = null;
        SemanticAdapter targetAdapter = null;
        if (sourceEditPart == null) {
            createCommand = this.getDefaultDropNodeCommand(this.getLinkSourceDropLocation(absoluteLocation, source, target), (EObject)source);
            cc.add((IUndoableOperation)createCommand);
            sourceAdapter = (IAdaptable)createCommand.getCommandResult().getReturnValue();
        } else {
            sourceAdapter = new SemanticAdapter(null, sourceEditPart.getModel());
        }
        if (targetEditPart == null) {
            createCommand = this.getDefaultDropNodeCommand(this.getLinkTargetDropLocation(absoluteLocation, source, target), (EObject)target);
            cc.add((IUndoableOperation)createCommand);
            targetAdapter = (IAdaptable)createCommand.getCommandResult().getReturnValue();
        } else {
            targetAdapter = new SemanticAdapter(null, targetEditPart.getModel());
        }
        CommonDeferredCreateConnectionViewCommand aLinkCommand = new CommonDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), sourceAdapter, targetAdapter, this.getViewer(), this.getDiagramPreferencesHint(), linkdescriptor, null);
        aLinkCommand.setElement((EObject)semanticLink);
        cc.compose((IUndoableOperation)aLinkCommand);
        return cc;
    }

    protected Point getLinkSourceDropLocation(Point absoluteLocation, Element source, Element target) {
        return absoluteLocation;
    }

    protected Point getLinkTargetDropLocation(Point absoluteLocation, Element source, Element target) {
        if (this.lookForEditPart((EObject)source) == null && this.lookForEditPart((EObject)target) == null) {
            return absoluteLocation.getTranslated(100, 0);
        }
        return absoluteLocation;
    }

    protected PreferencesHint getDiagramPreferencesHint() {
        return ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint();
    }

    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        ViewServiceUtil.forceLoad();
        if (dropRequest.getObjects().size() > 0 && dropRequest.getObjects().get(0) instanceof String) {
            return this.getDropFileCommand(dropRequest);
        }
        CompositeCommand cc = new CompositeCommand("Drop");
        for (EObject droppedObject : dropRequest.getObjects()) {
            cc.add(this.getDropObjectCommand(dropRequest, droppedObject));
        }
        return new ICommandProxy((ICommand)cc);
    }

    protected IUndoableOperation getDropObjectCommand(DropObjectsRequest dropRequest, EObject droppedObject) {
        Point location = dropRequest.getLocation().getCopy();
        int nodeVISUALID = this.getNodeVisualID(((IGraphicalEditPart)this.getHost()).getNotationView(), droppedObject);
        int linkVISUALID = this.getLinkWithClassVisualID(droppedObject);
        if (this.getSpecificDrop().contains(nodeVISUALID) || this.getSpecificDrop().contains(linkVISUALID)) {
            Command specificDropCommand = this.getSpecificDropCommand(dropRequest, (Element)droppedObject, nodeVISUALID, linkVISUALID);
            CompositeCommand cc = new CompositeCommand("Drop command");
            cc.compose((IUndoableOperation)new CommandProxy(specificDropCommand));
            if (this.isCopy(dropRequest)) {
                CompoundCommand specificDropCompoundCommand;
                ICommandProxy cp;
                if (specificDropCommand instanceof ICommandProxy) {
                    ICommandProxy specificDropCommandProxy = (ICommandProxy)specificDropCommand;
                    this.createDeferredCommandWithCommandResult(droppedObject, cc, specificDropCommandProxy);
                } else if (specificDropCommand instanceof CompoundCommand && (cp = this.getCommandProxyFromCompoundCommand(specificDropCompoundCommand = (CompoundCommand)specificDropCommand)) != null) {
                    this.createDeferredCommandWithCommandResult(droppedObject, cc, cp);
                }
            }
            return cc;
        }
        if (linkVISUALID == -1 && nodeVISUALID != -1) {
            EObject graphicalParent = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
            if (this.getHost().getModel() instanceof Diagram) {
                return this.getDefaultDropNodeCommand(nodeVISUALID, location, droppedObject, dropRequest);
            }
            if (graphicalParent instanceof Element && ((Element)graphicalParent).getOwnedElements().contains((Object)droppedObject)) {
                return this.getDefaultDropNodeCommand(nodeVISUALID, location, droppedObject, dropRequest);
            }
            return UnexecutableCommand.INSTANCE;
        }
        if (linkVISUALID != -1) {
            Collection<?> sources = this.linkmappingHelper.getSource((Element)droppedObject);
            Collection<?> targets = this.linkmappingHelper.getTarget((Element)droppedObject);
            if (sources.size() == 0 || targets.size() == 0) {
                return UnexecutableCommand.INSTANCE;
            }
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            CompositeCommand cc = new CompositeCommand("Add Link");
            this.dropBinaryLink(cc, source, target, linkVISUALID, location, (Element)droppedObject);
            return cc;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected ICommandProxy getCommandProxyFromCompoundCommand(CompoundCommand cc) {
        if (cc != null && cc.getCommands() != null) {
            for (Object command : cc.getCommands()) {
                if (command instanceof ICommandProxy) {
                    return (ICommandProxy)command;
                }
                if (!(command instanceof CompoundCommand)) continue;
                this.getCommandProxyFromCompoundCommand((CompoundCommand)command);
            }
        }
        return null;
    }

    protected void createDeferredCommandWithCommandResult(EObject droppedObject, CompositeCommand cc, ICommandProxy specificDropCommandProxy) {
        Object object;
        if (specificDropCommandProxy != null && specificDropCommandProxy.getICommand() != null && specificDropCommandProxy.getICommand().getCommandResult() != null && specificDropCommandProxy.getICommand().getCommandResult().getReturnValue() != null && (object = specificDropCommandProxy.getICommand().getCommandResult().getReturnValue()) instanceof Collection) {
            for (Object o : (Collection)object) {
                if (!(o instanceof CreateViewRequest.ViewDescriptor)) continue;
                CreateViewRequest.ViewDescriptor viewDescritor = (CreateViewRequest.ViewDescriptor)o;
                DeferredCreateCommand createCommand2 = new DeferredCreateCommand(this.getEditingDomain(), droppedObject, (IAdaptable)viewDescritor, this.getHost().getViewer());
                cc.compose((IUndoableOperation)createCommand2);
            }
        }
    }

    protected Point getTranslatedToRelative(Point absoluteLocation) {
        Point relativeLocation = absoluteLocation.getCopy();
        ((GraphicalEditPart)this.getHost()).getContentPane().translateToRelative((Translatable)relativeLocation);
        ((GraphicalEditPart)this.getHost()).getContentPane().translateFromParent((Translatable)relativeLocation);
        relativeLocation.translate(((GraphicalEditPart)this.getHost()).getContentPane().getClientArea().getLocation().getNegated());
        return relativeLocation;
    }

    protected ICommand getDefaultDropNodeCommand(int nodeVISUALID, Point absoluteLocation, EObject droppedObject, DropObjectsRequest request) {
        return this.getDefaultDropNodeCommand(this.getHost(), nodeVISUALID, absoluteLocation, droppedObject);
    }

    protected ICommand getDefaultDropNodeCommand(int nodeVISUALID, Point absoluteLocation, EObject droppedObject) {
        return this.getDefaultDropNodeCommand(nodeVISUALID, absoluteLocation, droppedObject, null);
    }

    protected ICommand getDefaultDropNodeCommand(Point absoluteLocation, EObject droppedObject) {
        return this.getDefaultDropNodeCommand(this.getHost(), null, absoluteLocation, droppedObject);
    }

    protected ICommand getDefaultDropNodeCommand(EditPart hostEP, Point absoluteLocation, EObject droppedObject) {
        return this.getDefaultDropNodeCommand(hostEP, null, absoluteLocation, droppedObject);
    }

    protected ICommand getDefaultDropNodeCommand(EditPart hostEP, int nodeVISUALID, Point absoluteLocation, EObject droppedObject, DropObjectsRequest request) {
        IHintedType type = (IHintedType)this.getUMLElementType(nodeVISUALID);
        String semanticHint = null;
        if (type != null) {
            semanticHint = type.getSemanticHint();
        }
        return this.getDefaultDropNodeCommand(this.getHost(), semanticHint, absoluteLocation, droppedObject, request);
    }

    protected ICommand getDefaultDropNodeCommand(EditPart hostEP, int nodeVISUALID, Point absoluteLocation, EObject droppedObject) {
        return this.getDefaultDropNodeCommand(hostEP, nodeVISUALID, absoluteLocation, droppedObject, null);
    }

    protected ICommand getDefaultDropNodeCommand(EditPart hostEP, String semanticHint, Point absoluteLocation, EObject droppedObject) {
        return this.getDefaultDropNodeCommand(hostEP, semanticHint, absoluteLocation, droppedObject, null);
    }

    protected ICommand getDefaultDropNodeCommand(EditPart hostEP, String semanticHint, Point absoluteLocation, EObject droppedObject, DropObjectsRequest request) {
        List<View> existingViews = DiagramEditPartsUtil.findViews(droppedObject, this.getViewer());
        if (existingViews.isEmpty()) {
            EObjectAdapter elementAdapter = new EObjectAdapter(droppedObject);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, semanticHint, -1, true, this.getDiagramPreferencesHint());
            CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
            createViewRequest.setLocation(absoluteLocation);
            Command command = hostEP.getCommand((Request)createViewRequest);
            if (this.isCopy(request) && createViewRequest.getNewObject() instanceof List) {
                for (Object object : (List)createViewRequest.getNewObject()) {
                    if (!(object instanceof IAdaptable)) continue;
                    DeferredCreateCommand createCommand2 = new DeferredCreateCommand(this.getEditingDomain(), droppedObject, (IAdaptable)object, this.getHost().getViewer());
                    command.chain((Command)new ICommandProxy((ICommand)createCommand2));
                }
            }
            return new CommandProxyWithResult(command, (Object)descriptor);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public boolean isCopy(DropObjectsRequest dropRequest) {
        int eventDetail;
        return dropRequest != null && dropRequest.getExtendedData() != null && dropRequest.getExtendedData().get("EVENT_DETAIL") instanceof Integer && ((eventDetail = ((Integer)dropRequest.getExtendedData().get("EVENT_DETAIL")).intValue()) & 1) != 0;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticLink, int nodeVISUALID, int linkVISUALID) {
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    protected EditPartViewer getViewer() {
        return ((IGraphicalEditPart)this.getHost()).getViewer();
    }

    protected EditPart lookForEditPart(EObject semantic) {
        Collection editPartSet = this.getHost().getViewer().getEditPartRegistry().values();
        Iterator editPartIterator = editPartSet.iterator();
        EditPart existedEditPart = null;
        while (editPartIterator.hasNext() && existedEditPart == null) {
            EditPart currentEditPart = (EditPart)editPartIterator.next();
            if (!this.isEditPartTypeAdapted(currentEditPart.getClass(), semantic.eClass()) || !semantic.equals(((GraphicalEditPart)currentEditPart).resolveSemanticElement())) continue;
            existedEditPart = currentEditPart;
        }
        return existedEditPart;
    }

    private boolean isEditPartTypeAdapted(Class<? extends EditPart> editPartClass, EClass eClass) {
        if (DiagramEditPart.class.isAssignableFrom(editPartClass) || CompartmentEditPart.class.isAssignableFrom(editPartClass)) {
            return false;
        }
        if (GraphicalEditPart.class.isAssignableFrom(editPartClass)) {
            return this.isEditPartTypeSuitableForEClass(editPartClass.asSubclass(GraphicalEditPart.class), eClass);
        }
        return false;
    }

    protected boolean isEditPartTypeSuitableForEClass(Class<? extends GraphicalEditPart> editPartClass, EClass eClass) {
        return true;
    }
}

