/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.parser.HTMLCleaner;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLCommentParser {
    public static NodeList parse(String text) {
        NodeList nodelist = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            String cleandText = HTMLCleaner.preClean(text);
            documentBuilder.setErrorHandler(new DefaultHandler());
            Document document = documentBuilder.parse(new InputSource(new StringReader(cleandText)));
            nodelist = document.getChildNodes();
        }
        catch (ParserConfigurationException e) {
            Activator.log.error((Throwable)e);
            nodelist = new EmptyNodeList();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
            nodelist = new EmptyNodeList();
        }
        catch (SAXException e) {
            nodelist = new EmptyNodeList();
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
            nodelist = new EmptyNodeList();
        }
        return nodelist;
    }

    public static class EmptyNodeList
    implements NodeList {
        public int getLength() {
            return 0;
        }

        public Node item(int index) {
            return null;
        }
    }
}

