/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.handlers.GraphicalCommandHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeleteFromModelCommandHandler
extends GraphicalCommandHandler
implements IHandler {
    private static final String DISPLAY_MESSAGE_FOR_DELETE_ACTION_PREFERENCE_KEY = "displayMessageForDeleteActionPreferenceKey";

    protected Command getCommand() throws ExecutionException {
        List<IGraphicalEditPart> editParts = this.getSelectedElements();
        if (editParts.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(this.getEditingDomain(), "Delete From Model");
        for (IGraphicalEditPart editPart : editParts) {
            Command curCommand;
            if (editPart instanceof DiagramEditPart || (curCommand = editPart.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)new DestroyElementRequest(false)))) == null) continue;
            command.compose((IUndoableOperation)new CommandProxy(curCommand));
        }
        if (command.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return new ICommandProxy((ICommand)command);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.canDoAction()) {
            return super.execute(event);
        }
        return null;
    }

    protected boolean canDoAction() {
        MessageDialogWithToggle toggle;
        int returnCode;
        String hideValue;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean contains = store.contains(DISPLAY_MESSAGE_FOR_DELETE_ACTION_PREFERENCE_KEY);
        if (!contains) {
            store.setValue(DISPLAY_MESSAGE_FOR_DELETE_ACTION_PREFERENCE_KEY, "never");
            store.setDefault(DISPLAY_MESSAGE_FOR_DELETE_ACTION_PREFERENCE_KEY, "never");
        }
        return (hideValue = store.getString(DISPLAY_MESSAGE_FOR_DELETE_ACTION_PREFERENCE_KEY)).equals("always") || (returnCode = (toggle = MessageDialogWithToggle.openYesNoQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Delete Action", (String)"WARNING! The Shorcuts for Hide and Delete actions have changed. \n \n Do you really want to delete an element of the model?", (String)"Don't show this dialog the next time", (boolean)false, (IPreferenceStore)store, (String)DISPLAY_MESSAGE_FOR_DELETE_ACTION_PREFERENCE_KEY)).getReturnCode()) == 2;
    }
}

