/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphicalCommandHandler
extends AbstractHandler {
    protected abstract org.eclipse.gef.commands.Command getCommand() throws ExecutionException;

    protected List<IGraphicalEditPart> getSelectedElements() {
        ISelection selection;
        ArrayList<IGraphicalEditPart> editparts = new ArrayList<IGraphicalEditPart>();
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection iSelection = selection = activeWorkbenchWindow != null ? activeWorkbenchWindow.getSelectionService().getSelection() : null;
        if (selection != null) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                for (Object object : structuredSelection) {
                    if (!(object instanceof IGraphicalEditPart)) continue;
                    editparts.add((IGraphicalEditPart)object);
                }
            } else if (selection instanceof IGraphicalEditPart) {
                editparts.add((IGraphicalEditPart)selection);
            }
        }
        return editparts;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        org.eclipse.gef.commands.Command command = this.getCommand();
        if (editingDomain != null && command != null) {
            editingDomain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper(command));
        }
        return null;
    }

    public boolean isEnabled() {
        try {
            org.eclipse.gef.commands.Command command = this.getCommand();
            if (command != null && command.canExecute()) {
                return true;
            }
        }
        catch (ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
        return false;
    }

    public boolean isVisible() {
        return this.isEnabled();
    }

    protected TransactionalEditingDomain getEditingDomain() {
        ServiceUtilsForActionHandlers serviceUtils = ServiceUtilsForActionHandlers.getInstance();
        TransactionalEditingDomain editingDomain = null;
        try {
            editingDomain = serviceUtils.getTransactionalEditingDomain();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return editingDomain;
    }
}

