/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class AssociationHelper {
    public static int source = 0;
    public static int target = 1;

    public static CommandResult reconnect(int end, Association association, Type newType) {
        ((Property)association.getMemberEnds().get(end)).setType(newType);
        return CommandResult.newOKCommandResult((Object)association);
    }

    public static IUndoableOperation createSetAggregationCommand(Property property, AggregationKind aggregationKind) {
        EAttribute feature = UMLPackage.eINSTANCE.getProperty_Aggregation();
        SetRequest setRequest = new SetRequest((EObject)property, (EStructuralFeature)feature, (Object)aggregationKind);
        SetValueCommand setValueCommand = new SetValueCommand(setRequest);
        return setValueCommand;
    }

    public static IUndoableOperation createSetOwnerCommand(Association association, Property property, boolean belongsToClass) {
        Type owner = null;
        if (belongsToClass) {
            if (!(property.getOwner() instanceof Association)) {
                return null;
            }
            EList ownerList = association.getEndTypes();
            owner = ((Type)ownerList.get(0)).equals(property.getType()) && ownerList.size() > 1 ? (Type)ownerList.get(1) : (Type)ownerList.get(0);
            EReference feature = UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute();
            if (owner instanceof Class) {
                ArrayList<Property> attributeList = new ArrayList<Property>();
                attributeList.addAll((Collection<Property>)((Class)owner).getAttributes());
                attributeList.add(property);
                SetRequest setRequest = new SetRequest((EObject)owner, (EStructuralFeature)feature, attributeList);
                SetValueCommand setValueCommand = new SetValueCommand(setRequest);
                return setValueCommand;
            }
            return UnexecutableCommand.INSTANCE;
        }
        EReference feature = UMLPackage.eINSTANCE.getAssociation_OwnedEnd();
        ArrayList<Property> attributeList = new ArrayList<Property>();
        attributeList.addAll((Collection<Property>)property.getAssociation().getOwnedEnds());
        attributeList.add(property);
        SetRequest setRequest = new SetRequest((EObject)property.getAssociation(), (EStructuralFeature)feature, attributeList);
        SetValueCommand setValueCommand = new SetValueCommand(setRequest);
        return setValueCommand;
    }

    public static IUndoableOperation createSetMultiplicityCommand(Property property, int lower, int upper) {
        EAttribute lowerFeature = UMLPackage.eINSTANCE.getMultiplicityElement_Lower();
        EAttribute upperFeature = UMLPackage.eINSTANCE.getMultiplicityElement_Upper();
        CompositeCommand compositeCommand = new CompositeCommand("Set Multiplicity");
        SetRequest setLowerRequest = new SetRequest((EObject)property, (EStructuralFeature)lowerFeature, (Object)lower);
        compositeCommand.compose((IUndoableOperation)new SetValueCommand(setLowerRequest));
        SetRequest setUpperRequest = new SetRequest((EObject)property, (EStructuralFeature)upperFeature, (Object)upper);
        compositeCommand.compose((IUndoableOperation)new SetValueCommand(setUpperRequest));
        return compositeCommand;
    }

    public static IUndoableOperation createSetNavigableCommand(Association association, Property property, boolean isNavigable) {
        EReference feature = UMLPackage.eINSTANCE.getAssociation_NavigableOwnedEnd();
        ArrayList<Property> attributeList = new ArrayList<Property>();
        attributeList.addAll((Collection<Property>)property.getAssociation().getNavigableOwnedEnds());
        if (isNavigable) {
            attributeList.add(property);
        } else {
            attributeList.remove(property);
        }
        SetRequest setRequest = new SetRequest((EObject)property.getAssociation(), (EStructuralFeature)feature, attributeList);
        return new SetValueCommand(setRequest);
    }
}

