/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.uml.diagram.common.parser.lookup.Lookup;
import org.eclipse.uml2.uml.NamedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLLookup<T extends NamedElement>
implements Lookup<T> {
    private Expression mySelector;
    private final ArrayList<IElementType> myResolutionTypes;
    private static final IElementType[] NO_RESOLUTIONS = new IElementType[0];

    public OCLLookup(Expression ocl) {
        this(ocl, NO_RESOLUTIONS);
    }

    public OCLLookup(Expression ocl, IElementType[] resolutions) {
        this.mySelector = ocl;
        if (resolutions == null) {
            resolutions = NO_RESOLUTIONS;
        }
        this.myResolutionTypes = new ArrayList<IElementType>(Arrays.asList(resolutions));
    }

    @Override
    public List getResolutionElementTypes() {
        return new ArrayList<IElementType>(this.myResolutionTypes);
    }

    public List<T> computeScope(EObject context) {
        Object result = this.mySelector.evaluate(context);
        if (result instanceof Collection) {
            return new LinkedList((Collection)result);
        }
        return Collections.emptyList();
    }

    @Override
    public T lookup(String name, EObject context) {
        List<T> scope = this.computeScope(context);
        for (NamedElement next : scope) {
            if (!name.equals(next.getName()) && !name.equals(next.getQualifiedName())) continue;
            return (T)next;
        }
        return null;
    }

    public static interface Expression {
        public Object evaluate(Object var1);
    }
}

