/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.util;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class UMLSelectionTester
extends PropertyTester {
    public static final String IS_UML_MODEL = "isUMLModel";
    public static final String IS_UML_PROFILE = "isUMLProfile";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IMultiDiagramEditor editor = EditorUtils.getMultiDiagramEditor();
        if (editor == null) {
            return false;
        }
        Boolean currentValue = null;
        if (IS_UML_MODEL.equals(property)) {
            currentValue = this.testUMLModelNature(receiver);
            return currentValue == expectedValue;
        }
        if (IS_UML_PROFILE.equals(property)) {
            currentValue = this.testUMLProfileNature(receiver);
            return currentValue == expectedValue;
        }
        return false;
    }

    protected boolean testUMLModelNature(Object receiver) {
        EObject root = this.getRoot();
        return root instanceof Package && !(root instanceof Profile);
    }

    protected boolean testUMLProfileNature(Object receiver) {
        return this.getRoot() instanceof Profile;
    }

    private EObject getRoot() {
        EObject root = null;
        try {
            ServiceUtilsForActionHandlers serviceUtils = ServiceUtilsForActionHandlers.getInstance();
            UmlModel openedModel = (UmlModel)serviceUtils.getModelSet().getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
            if (openedModel != null) {
                root = openedModel.lookupRoot();
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        catch (NotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        return root;
    }
}

