/*
 * Copyright (c) 2012 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.papyrus.uml.diagram.timing.sheet;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AdvancedPropertySection;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

/**
 * @generated
 */
@SuppressWarnings("all")
// disable warnings on generated code
public class UMLPropertySection extends AdvancedPropertySection implements IPropertySourceProvider {

	/**
	 * @generated
	 */
	public IPropertySource getPropertySource(final Object object) {
		if(object instanceof IPropertySource) {
			return (IPropertySource)object;
		}
		final AdapterFactory af = getAdapterFactory(object);
		if(af != null) {
			final IItemPropertySource ips = (IItemPropertySource)af.adapt(object, IItemPropertySource.class);
			if(ips != null) {
				return new PropertySource(object, ips);
			}
		}
		if(object instanceof IAdaptable) {
			return (IPropertySource)((IAdaptable)object).getAdapter(IPropertySource.class);
		}
		return null;
	}

	/**
	 * @generated
	 */
	@Override
	protected IPropertySourceProvider getPropertySourceProvider() {
		return this;
	}

	/**
	 * Modify/unwrap selection.
	 * 
	 * @generated
	 */
	protected Object transformSelection(final Object selected) {

		if(selected instanceof EditPart) {
			final Object model = ((EditPart)selected).getModel();
			return model instanceof View ? ((View)model).getElement() : null;
		}
		if(selected instanceof View) {
			return ((View)selected).getElement();
		}
		if(selected instanceof IAdaptable) {
			final View view = (View)((IAdaptable)selected).getAdapter(View.class);
			if(view != null) {
				return view.getElement();
			}
		}
		return selected;
	}

	/**
	 * @generated
	 */
	@Override
	public void setInput(final IWorkbenchPart part, final ISelection selection) {
		if(selection.isEmpty() || false == selection instanceof StructuredSelection) {
			super.setInput(part, selection);
			return;
		}
		final StructuredSelection structuredSelection = ((StructuredSelection)selection);
		final ArrayList transformedSelection = new ArrayList(structuredSelection.size());
		for(final Iterator it = structuredSelection.iterator(); it.hasNext();) {
			final Object r = transformSelection(it.next());
			if(r != null) {
				transformedSelection.add(r);
			}
		}
		super.setInput(part, new StructuredSelection(transformedSelection));
	}

	/**
	 * @generated
	 */
	protected AdapterFactory getAdapterFactory(final Object object) {
		if(getEditingDomain() instanceof AdapterFactoryEditingDomain) {
			return ((AdapterFactoryEditingDomain)getEditingDomain()).getAdapterFactory();
		}
		final TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain(object);
		if(editingDomain != null) {
			return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
		}
		return null;
	}

}
