/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.validation.problems.edit;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.papyrus.cdo.validation.problems.EProblem;
import org.eclipse.papyrus.cdo.validation.problems.edit.IProblemTypeProvider;

public class ProblemEditUtil {
    private AdapterFactory adapterFactory;
    private DefaultProblemTypeProviderAdapter defaultAdapter;

    public ProblemEditUtil(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public String getProblemType(EProblem problem) {
        IProblemTypeProvider provider = this.getProblemTypeProvider(problem);
        return provider.getProblemType(problem);
    }

    protected IProblemTypeProvider getProblemTypeProvider(EProblem problem) {
        IProblemTypeProvider result;
        Adapter provider = this.adapterFactory.adapt((Notifier)problem, IProblemTypeProvider.class);
        IProblemTypeProvider iProblemTypeProvider = result = provider instanceof IProblemTypeProvider ? (IProblemTypeProvider)provider : null;
        if (result == null) {
            for (Adapter next : problem.eAdapters()) {
                if (!(next instanceof IProblemTypeProvider)) continue;
                result = (IProblemTypeProvider)next;
                break;
            }
        }
        if (result == null) {
            DefaultProblemTypeProviderAdapter adapter = this.getDefaultProblemTypeProvider();
            problem.eAdapters().add((Object)adapter);
            result = adapter;
        }
        return result;
    }

    protected DefaultProblemTypeProviderAdapter getDefaultProblemTypeProvider() {
        if (this.defaultAdapter == null) {
            this.defaultAdapter = new DefaultProblemTypeProviderAdapter();
        }
        return this.defaultAdapter;
    }

    protected class DefaultProblemTypeProviderAdapter
    implements Adapter,
    IProblemTypeProvider {
        protected DefaultProblemTypeProviderAdapter() {
        }

        public String getProblemType(Object object) {
            EProblem problem;
            EObject element;
            String result = null;
            if (object instanceof EProblem && (element = (problem = (EProblem)object).getElement()) != null) {
                EPackage model = element.eClass().getEPackage();
                IItemLabelProvider labels = (IItemLabelProvider)ProblemEditUtil.this.adapterFactory.adapt((Notifier)model, IItemLabelProvider.class);
                result = labels != null ? labels.getText((Object)model) : model.getName();
            }
            return result;
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }

        public Notifier getTarget() {
            return null;
        }

        public void setTarget(Notifier newTarget) {
        }

        public void notifyChanged(Notification notification) {
        }
    }
}

