/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.ATTRIBUTE_OP;
import org.eclipse.papyrus.infra.gmfdiag.css.Attribute;
import org.eclipse.papyrus.infra.gmfdiag.css.AttributeValue;
import org.eclipse.papyrus.infra.gmfdiag.css.Class;
import org.eclipse.papyrus.infra.gmfdiag.css.CompositeSelector;
import org.eclipse.papyrus.infra.gmfdiag.css.CssFactory;
import org.eclipse.papyrus.infra.gmfdiag.css.Declaration;
import org.eclipse.papyrus.infra.gmfdiag.css.Expression;
import org.eclipse.papyrus.infra.gmfdiag.css.Ruleset;
import org.eclipse.papyrus.infra.gmfdiag.css.Selector;
import org.eclipse.papyrus.infra.gmfdiag.css.SelectorCondition;
import org.eclipse.papyrus.infra.gmfdiag.css.SimpleSelector;
import org.eclipse.papyrus.infra.gmfdiag.css.Stylesheet;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler.AbstractStyleDialog;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler.GMFToCSSConverter;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.helper.DiagramTypeHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.BaseCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.provider.CustomStyle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStyleHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        String selectorName;
        Map<Attribute, Boolean> conditions;
        ISelection selection;
        try {
            selection = ServiceUtilsForHandlers.getInstance().getNestedActiveIEditorPart((Object)event).getSite().getSelectionProvider().getSelection();
            if (selection.isEmpty()) {
                return null;
            }
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        Object element = sSelection.getFirstElement();
        View view = NotationHelper.findView((Object)element);
        if (view == null) {
            Activator.log.warn("Cannot create a Style from the selected element ; the element is not a View");
            return null;
        }
        Shell parentShell = ((Event)event.getTrigger()).widget.getDisplay().getActiveShell();
        if (view.getElement() == null || view instanceof Diagram) {
            MessageDialog.open((int)4, (Shell)parentShell, (String)"Style error", (String)"The selected element's style cannot be exported", (int)0);
            return null;
        }
        Map<Declaration, Boolean> declarations = this.handleStyles(view);
        AbstractStyleDialog dialog = this.createStyleDialog(parentShell, declarations, conditions = this.handleSemantic(view), selectorName = view.getElement().eClass().getName(), view);
        if (dialog.open() != 0) {
            return null;
        }
        Ruleset ruleset = this.getRuleset(dialog);
        SimpleSelector selector = CssFactory.eINSTANCE.createSimpleSelector();
        if (dialog.useSelectorName()) {
            selector.setElementName(selectorName);
        } else {
            selector.setElementName("*");
        }
        if (dialog.getDiagramRestriction()) {
            String string = DiagramTypeHelper.getDiagramType(view.getDiagram());
            CompositeSelector compositeSelector = CssFactory.eINSTANCE.createCompositeSelector();
            compositeSelector.setRight((Selector)selector);
            SimpleSelector diagramSelector = CssFactory.eINSTANCE.createSimpleSelector();
            diagramSelector.setElementName(string);
            compositeSelector.setLeft(diagramSelector);
            ruleset.getSelectors().add((Object)compositeSelector);
        } else {
            ruleset.getSelectors().add((Object)selector);
        }
        if (dialog.getCSSClass() != null) {
            String string = dialog.getCSSClass();
            Class classCondition = CssFactory.eINSTANCE.createClass();
            classCondition.setClass(string);
            selector.getCondition().add((Object)classCondition);
        }
        for (SelectorCondition selectorCondition : conditions.keySet()) {
            if (!conditions.get(selectorCondition).booleanValue()) continue;
            selector.getCondition().add((Object)selectorCondition);
        }
        for (Declaration declaration : declarations.keySet()) {
            if (!declarations.get(declaration).booleanValue()) continue;
            ruleset.getProperties().add((Object)declaration);
        }
        Stylesheet stylesheet = this.getStyleSheet(dialog, view);
        if (stylesheet == null) {
            return null;
        }
        Resource resource = stylesheet.eResource();
        if (!stylesheet.getContents().contains((Object)ruleset)) {
            stylesheet.getContents().add((Object)ruleset);
        }
        try {
            resource.save(new HashMap());
            BaseCSSEngine.instance.reset();
            DiagramHelper.setNeedsRefresh();
            DiagramHelper.refreshDiagrams();
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
            MessageDialog.open((int)1, (Shell)parentShell, (String)"Style error", (String)"An unexpected error occured while trying to save the Stylesheet", (int)0);
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            MessageDialog.open((int)1, (Shell)parentShell, (String)"Style error", (String)"An unexpected error occured while trying to save the Stylesheet", (int)0);
        }
        return null;
    }

    protected abstract AbstractStyleDialog createStyleDialog(Shell var1, Map<Declaration, Boolean> var2, Map<Attribute, Boolean> var3, String var4, View var5);

    protected abstract Ruleset getRuleset(AbstractStyleDialog var1);

    protected abstract Stylesheet getStyleSheet(AbstractStyleDialog var1, View var2);

    protected Map<Declaration, Boolean> handleStyles(View view) {
        LinkedHashMap<Declaration, Boolean> declarations = new LinkedHashMap<Declaration, Boolean>();
        for (Object styleObject : view.getStyles()) {
            Style style = (Style)styleObject;
            declarations.putAll(this.handleStyle(style));
        }
        if (view instanceof Style) {
            declarations.putAll(this.handleStyle((Style)view));
        }
        if (view instanceof CustomStyle) {
            declarations.putAll(this.handleCustomStyle((CustomStyle)view, view));
        }
        return declarations;
    }

    protected Map<Attribute, Boolean> handleSemantic(View view) {
        LinkedHashMap<Attribute, Boolean> result = new LinkedHashMap<Attribute, Boolean>();
        EObject semanticElement = view.getElement();
        for (EStructuralFeature feature : semanticElement.eClass().getEAllStructuralFeatures()) {
            if (!this.isBoolean(feature) && !this.isInteger(feature) && !(feature.getEType() instanceof EEnum)) continue;
            Attribute attributeCondition = CssFactory.eINSTANCE.createAttribute();
            attributeCondition.setName(feature.getName());
            AttributeValue attributeValue = CssFactory.eINSTANCE.createAttributeValue();
            attributeValue.setOperator(ATTRIBUTE_OP.EQUALS);
            attributeValue.setValue(semanticElement.eGet(feature).toString());
            attributeCondition.setValue(attributeValue);
            boolean check = semanticElement.eGet(feature) != feature.getDefaultValue();
            result.put(attributeCondition, check);
        }
        return result;
    }

    protected boolean isBoolean(EStructuralFeature feature) {
        if (feature.getEType() == EcorePackage.eINSTANCE.getEBoolean() || feature.getEType() == EcorePackage.eINSTANCE.getEBooleanObject()) {
            return true;
        }
        if (feature.getEType() instanceof EDataType) {
            EDataType datatype = (EDataType)feature.getEType();
            return datatype.getName().equals("Boolean");
        }
        return false;
    }

    protected boolean isString(EStructuralFeature feature) {
        return feature.getEType() == EcorePackage.eINSTANCE.getEString();
    }

    protected boolean isInteger(EStructuralFeature feature) {
        if (feature.getEType() == EcorePackage.eINSTANCE.getEInt() || feature.getEType() == EcorePackage.eINSTANCE.getEIntegerObject()) {
            return true;
        }
        if (feature.getEType() instanceof EDataType) {
            EDataType datatype = (EDataType)feature.getEType();
            return datatype.getName().equals("Integer");
        }
        return false;
    }

    protected Map<Declaration, Boolean> handleStyle(Style style) {
        if (style instanceof NamedStyle) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Declaration, Boolean> declarations = new LinkedHashMap<Declaration, Boolean>();
        for (EStructuralFeature feature : style.eClass().getEAllStructuralFeatures()) {
            if (!NotationPackage.eINSTANCE.getStyle().isSuperTypeOf(feature.getEContainingClass())) continue;
            boolean check = style.eGet(feature) != feature.getDefaultValue();
            declarations.put(this.handleStyleFeature(style, feature), check);
        }
        return declarations;
    }

    protected Map<Declaration, Boolean> handleCustomStyle(CustomStyle customStyle, View view) {
        LinkedHashMap<Declaration, Boolean> declarations = new LinkedHashMap<Declaration, Boolean>();
        GMFToCSSConverter converter = GMFToCSSConverter.instance;
        this.handleCustomStyle(view, "elementIcon", "displayNameLabelIcon", declarations, converter.convert(customStyle.showElementIcon()));
        this.handleCustomStyle(view, "shadow", "ShadowFigure", declarations, converter.convert(customStyle.showShadow()));
        this.handleCustomStyle(view, "qualifiedNameDepth", "QualifiedName", declarations, converter.convert(customStyle.getQualifiedNameDepth()));
        return declarations;
    }

    protected void handleCustomStyle(View view, String cssProperty, String eAnnotationName, Map<Declaration, Boolean> result, Expression value) {
        Declaration cssDeclaration = CssFactory.eINSTANCE.createDeclaration();
        cssDeclaration.setProperty(cssProperty);
        cssDeclaration.setExpression(value);
        boolean check = view.getEAnnotation(eAnnotationName) != null;
        result.put(cssDeclaration, check);
    }

    protected Declaration handleStyleFeature(Style style, EStructuralFeature feature) {
        Declaration declaration = CssFactory.eINSTANCE.createDeclaration();
        declaration.setProperty(feature.getName());
        GMFToCSSConverter converter = GMFToCSSConverter.instance;
        if (this.isString(feature)) {
            declaration.setExpression(converter.convert((String)style.eGet(feature)));
        }
        if (this.isInteger(feature)) {
            if (feature.getName().endsWith("Color")) {
                Color color = FigureUtilities.integerToColor((Integer)((Integer)style.eGet(feature)));
                declaration.setExpression(converter.convert(color));
                color.dispose();
            } else {
                declaration.setExpression(converter.convert((Integer)style.eGet(feature)));
            }
        }
        if (feature.getEType() == NotationPackage.eINSTANCE.getGradientData()) {
            declaration.setExpression(converter.convert((GradientData)style.eGet(feature)));
        }
        if (feature.getEType() instanceof EEnum) {
            declaration.setExpression(converter.convert((Enumerator)style.eGet(feature)));
        }
        if (this.isBoolean(feature)) {
            declaration.setExpression(converter.convert((Boolean)style.eGet(feature)));
        }
        return declaration;
    }
}

