/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.dialog;

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.editors.StringFileSelector;
import org.eclipse.papyrus.uml.export.messages.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Profile;

public class ExportProfilesParametersDialog
extends TrayDialog {
    private String pluginName;
    private String pluginProvider;
    private String pluginVersion;
    private String pluginExecEnvironment;
    private StringEditor pluginNameEditor;
    private StringEditor pluginProviderEditor;
    private StringEditor pluginVersionEditor;
    private StringEditor pluginExecEnvironmentEditor;
    private Object[] profiles;
    private String[] profilesIcons = new String[10];
    private StringFileSelector[] profileIconEditors = new StringFileSelector[10];

    public ExportProfilesParametersDialog(Shell shell, String pluginName, String pluginProvider, String pluginVersion, String execEnvironment, Object[] profiles) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setPluginName(pluginName == null ? "" : pluginName);
        this.setPluginProvider(pluginProvider == null ? "" : pluginProvider);
        this.setPluginVersion(pluginVersion == null ? "" : pluginVersion);
        this.setPluginExecEnvironment(execEnvironment == null ? "" : execEnvironment);
        this.profiles = profiles;
    }

    public void create() {
        super.create();
        this.createEditors();
    }

    protected void createEditors() {
        GridData data = new GridData();
        data = new GridData(768);
        data.horizontalSpan = 2;
        Composite parent = (Composite)this.getDialogArea();
        this.pluginNameEditor = new StringEditor(parent, 0, Messages.ExportProfilesParametersDialog_0);
        this.pluginNameEditor.setValue((Object)this.getPluginName());
        this.pluginNameEditor.setLayoutData((Object)data);
        this.pluginNameEditor.setToolTipText(Messages.ExportProfilesParametersDialog_1);
        this.pluginProviderEditor = new StringEditor(parent, 2048, Messages.ExportProfilesParametersDialog_2);
        this.pluginProviderEditor.setValue((Object)this.getPluginProvider());
        this.pluginProviderEditor.setLayoutData((Object)data);
        this.pluginProviderEditor.setToolTipText(Messages.ExportProfilesParametersDialog_7);
        this.pluginVersionEditor = new StringEditor(parent, 2048, Messages.ExportProfilesParametersDialog_8);
        this.pluginVersionEditor.setValue((Object)this.getPluginVersion());
        this.pluginVersionEditor.setLayoutData((Object)data);
        this.pluginVersionEditor.setToolTipText(Messages.ExportProfilesParametersDialog_9);
        this.pluginExecEnvironmentEditor = new StringEditor(parent, 2048, Messages.ExportProfilesParametersDialog_10);
        this.pluginExecEnvironmentEditor.setValue((Object)this.getPluginExecEnvironment());
        this.pluginExecEnvironmentEditor.setLayoutData((Object)data);
        this.pluginExecEnvironmentEditor.setToolTipText(Messages.ExportProfilesParametersDialog_11);
        int i = 0;
        while (i < this.profiles.length) {
            this.profileIconEditors[i] = new StringFileSelector(parent, 2048);
            this.profileIconEditors[i].setLayoutData((Object)data);
            this.profileIconEditors[i].setLabel("Icon for " + ((Profile)this.profiles[i]).getName());
            this.profileIconEditors[i].setToolTipText("Enter the profile icon");
            ++i;
        }
        this.getShell().setSize(800, 350);
        this.getShell().setText(Messages.ExportProfilesParametersDialog_12);
        this.getShell().layout();
    }

    protected void okPressed() {
        int i = 0;
        while (i < this.profileIconEditors.length) {
            if (this.profileIconEditors[i] == null) break;
            this.profilesIcons[i] = (String)this.profileIconEditors[i].getValue();
            ++i;
        }
        this.pluginExecEnvironment = (String)this.pluginExecEnvironmentEditor.getValue();
        this.pluginName = (String)this.pluginNameEditor.getValue();
        this.pluginProvider = (String)this.pluginProviderEditor.getValue();
        this.pluginVersion = (String)this.pluginVersionEditor.getValue();
        super.okPressed();
    }

    public String getPluginName() {
        return this.pluginName;
    }

    private void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getPluginProvider() {
        return this.pluginProvider;
    }

    private void setPluginProvider(String pluginProvider) {
        this.pluginProvider = pluginProvider;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    private void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public String getPluginExecEnvironment() {
        return this.pluginExecEnvironment;
    }

    private void setPluginExecEnvironment(String execEnvironment) {
        this.pluginExecEnvironment = execEnvironment;
    }

    public String[] getProfilesIcons() {
        return this.profilesIcons;
    }
}

