/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.editpolicies;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.StatefulView;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenerEditPolicy
extends AbstractEditPolicy
implements EditPolicy,
FocusListener,
EditPartListener,
MouseMotionListener {
    public static final String ROLE = "EVENT_LISTENER";
    private final Set<String> state = new HashSet<String>();

    public void activate() {
        this.getHost().getFigure().addFocusListener((FocusListener)this);
        this.getHost().getFigure().addMouseMotionListener((MouseMotionListener)this);
        this.getHost().addEditPartListener((EditPartListener)this);
    }

    public void deactivate() {
        this.getHost().getFigure().removeFocusListener((FocusListener)this);
        this.getHost().getFigure().removeMouseMotionListener((MouseMotionListener)this);
        this.getHost().removeEditPartListener((EditPartListener)this);
    }

    private void removeState(String ... states) {
        HashSet<String> statesToRemove = new HashSet<String>();
        String[] stringArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            String state = stringArray[n2];
            statesToRemove.add(state);
            ++n2;
        }
        this.state.removeAll(statesToRemove);
        StatefulView view = this.getDomElement();
        if (view != null) {
            view.removeStates(statesToRemove);
        }
    }

    private void addState(String ... states) {
        HashSet<String> newStates = new HashSet<String>();
        String[] stringArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            String state = stringArray[n2];
            newStates.add(state);
            ++n2;
        }
        this.state.addAll(newStates);
        StatefulView view = this.getDomElement();
        if (view != null) {
            view.addStates(newStates);
        }
    }

    private StatefulView getDomElement() {
        EventListenerEditPolicy primaryEditPolicy = this.getPrimaryEditPolicy();
        if (primaryEditPolicy == this) {
            Element domElement;
            View view = this.getSemanticView();
            if (view.getDiagram() instanceof CSSDiagram && (domElement = ((CSSDiagram)view.getDiagram()).getEngine().getElement(view)) instanceof StatefulView) {
                return (StatefulView)((Object)domElement);
            }
        } else if (primaryEditPolicy != null) {
            return primaryEditPolicy.getDomElement();
        }
        return null;
    }

    protected View getSemanticView() {
        return (View)this.getHost().getModel();
    }

    private EventListenerEditPolicy getPrimaryEditPolicy() {
        GraphicalEditPart current = this.getHost();
        EditPart parent = current.getParent();
        while (parent != null && this.semanticCompareEditParts(parent, (EditPart)this.getHost())) {
            current = parent;
            parent = parent.getParent();
        }
        return (EventListenerEditPolicy)current.getEditPolicy((Object)ROLE);
    }

    private boolean semanticCompareEditParts(EditPart one, EditPart other) {
        if (one.getModel() instanceof View && other.getModel() instanceof View) {
            View view1 = (View)one.getModel();
            View view2 = (View)other.getModel();
            return view1 != null && view2 != null && view1.getElement() == view2.getElement();
        }
        return false;
    }

    public Set<String> getState() {
        Set<String> state = this.state;
        Collection<EditPart> childEditParts = this.getChildEditParts();
        for (EditPart editPart : childEditParts) {
            EventListenerEditPolicy childEditPolicy = this.getEditPolicy(editPart);
            if (childEditPolicy == null) continue;
            Set<String> childState = childEditPolicy.getState();
            state.addAll(childState);
        }
        return state;
    }

    private EventListenerEditPolicy getEditPolicy(EditPart editPart) {
        return (EventListenerEditPolicy)editPart.getEditPolicy((Object)ROLE);
    }

    private Collection<EditPart> getChildEditParts() {
        LinkedList<EditPart> result = new LinkedList<EditPart>();
        for (Object editPart : this.getHost().getChildren()) {
            if (!this.semanticCompareEditParts((EditPart)this.getHost(), (EditPart)editPart)) continue;
            result.add((EditPart)editPart);
        }
        return result;
    }

    public GraphicalEditPart getHost() {
        return (GraphicalEditPart)super.getHost();
    }

    public void selectedStateChanged(EditPart editpart) {
        if ((editpart.getSelected() & 3) != 0) {
            this.addState("active", "focus");
        } else {
            this.removeState("active", "focus");
        }
    }

    public void focusGained(FocusEvent fe) {
        this.addState("focus");
    }

    public void focusLost(FocusEvent fe) {
        this.removeState("focus");
    }

    public void mouseEntered(MouseEvent me) {
        this.addState("hover");
    }

    public void mouseExited(MouseEvent me) {
        this.removeState("hover");
    }

    public void mouseHover(MouseEvent me) {
        this.addState("hover");
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
    }

    public void childAdded(EditPart child, int index) {
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
    }
}

