/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.engine;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.SemanticElementHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngineImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.GMFElementProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.w3c.dom.Element;

public class DiagramCSSEngine
extends ExtendedCSSEngineImpl
implements IChangeListener {
    private CSSDiagram diagram;

    public DiagramCSSEngine(ExtendedCSSEngine parent, CSSDiagram diagram) {
        super(parent);
        this.diagram = diagram;
        this.setElementProvider(new GMFElementProvider());
    }

    protected void reloadStyleSheets() {
        this.styleSheets.clear();
        for (StyleSheet styleSheet : this.diagram.getStyleSheets()) {
            this.styleSheets.add(styleSheet);
        }
    }

    protected void parseStyleSheet(StyleSheetReference styleSheet) throws IOException {
        URL url;
        String path = styleSheet.getPath();
        if (path.startsWith("/")) {
            path = "platform:/resource" + path;
            url = new URL(path);
            try {
                url.openConnection();
            }
            catch (IOException ex) {
                path = "platform:/plugin" + styleSheet.getPath();
            }
        } else {
            URI uri = URI.createURI((String)styleSheet.getPath());
            uri = uri.resolve(this.diagram.eResource().getURI());
            path = uri.toString();
        }
        url = new URL(path);
        this.parseStyleSheet(url.openStream());
    }

    public EObject getNativeWidget(Object element) {
        if ((element = super.getNativeWidget(element)) == null) {
            return null;
        }
        if (!(element instanceof EObject)) {
            throw new IllegalArgumentException("Unknown element : " + element);
        }
        return (EObject)element;
    }

    public void handleChange(ChangeEvent event) {
        this.resetCache();
        DiagramHelper.setNeedsRefresh();
        DiagramHelper.refreshDiagrams();
    }

    public Element getElement(Object node) {
        if (node == null) {
            return null;
        }
        EObject notationElement = this.getNativeWidget(node);
        View canonicalNotationElement = SemanticElementHelper.findPrimaryView((EObject)notationElement);
        return super.getElement((Object)canonicalNotationElement);
    }
}

