/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.engine;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.dom.parsers.CSSParser;
import org.eclipse.e4.ui.css.core.dom.parsers.CSSParserFactory;
import org.eclipse.e4.ui.css.core.dom.parsers.ICSSParserFactory;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverter;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.engine.AbstractCSSEngine;
import org.eclipse.e4.ui.css.core.impl.sac.CSSConditionFactoryImpl;
import org.eclipse.e4.ui.css.core.impl.sac.CSSSelectorFactoryImpl;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.converters.BooleanConverter;
import org.eclipse.papyrus.infra.gmfdiag.css.converters.ColorToGMFConverter;
import org.eclipse.papyrus.infra.gmfdiag.css.converters.IntegerConverter;
import org.eclipse.papyrus.infra.gmfdiag.css.converters.StringConverter;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.GMFErrorHandler;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.enginecopy.ExtendedViewCSSImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.listener.StyleSheetChangeListener;
import org.eclipse.papyrus.infra.gmfdiag.css.lists.ExtendedStyleSheetList;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.EmbeddedStyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.swt.widgets.Display;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.ViewCSS;

public abstract class ExtendedCSSEngineImpl
extends AbstractCSSEngine
implements ExtendedCSSEngine,
StyleSheetChangeListener {
    public static final ConditionFactory CONDITIONFACTORY_INSTANCE = new CSSConditionFactoryImpl(null, "class", null, "id");
    private final Map<Element, CSSStyleDeclaration> declarationsCache = new HashMap<Element, CSSStyleDeclaration>();
    private ExtendedViewCSSImpl viewCSS;
    protected ExtendedCSSEngine parent;
    private ExtendedStyleSheetList styleSheetsList;
    private final Set<StyleSheetChangeListener> styleSheetListeners = new HashSet<StyleSheetChangeListener>();
    private final Map<String, Collection<String>> availableClasses = new HashMap<String, Collection<String>>();
    protected final List<StyleSheet> styleSheets = new LinkedList<StyleSheet>();
    protected final List<URL> styleSheetURLs = new LinkedList<URL>();

    public ExtendedCSSEngineImpl() {
        this(null);
    }

    public ExtendedCSSEngineImpl(ExtendedCSSEngine parent) {
        this.init(parent);
    }

    public ExtendedCSSEngineImpl(ExtendedCSSEngine parent, ExtendedDocumentCSS documentCSS) {
        super(documentCSS);
        this.init(parent);
    }

    private void init(ExtendedCSSEngine parent) {
        if (parent != null) {
            parent.addStyleSheetChangeListener(this);
        }
        this.viewCSS = new ExtendedViewCSSImpl(this);
        this.parent = parent;
        this.registerCSSValueConverter((ICSSValueConverter)new ColorToGMFConverter());
        this.registerCSSValueConverter((ICSSValueConverter)new IntegerConverter());
        this.registerCSSValueConverter((ICSSValueConverter)new StringConverter());
        this.registerCSSValueConverter((ICSSValueConverter)new BooleanConverter());
        this.setErrorHandler(new GMFErrorHandler());
    }

    public String retrieveCSSProperty(Object widget, String property, String pseudo) {
        Element element = widget instanceof Element ? (Element)widget : this.getElement(widget);
        CSSValue value = this.retrievePropertyValue(element, property);
        if (value == null) {
            return null;
        }
        return value.getCssText();
    }

    public CSSValue retrievePropertyValue(Object node, String property) {
        if (node == null || property == null) {
            return null;
        }
        CSSStyleDeclaration declaration = this.getStyleDeclaration(node);
        return declaration.getPropertyCSSValue(property);
    }

    private CSSStyleDeclaration getStyleDeclaration(Object node) {
        return this.getStyleDeclaration(node, null);
    }

    private CSSStyleDeclaration getStyleDeclaration(Object node, String pseudo) {
        Element element = this.getElement(node);
        if (!this.declarationsCache.containsKey(element)) {
            this.declarationsCache.put(element, this.getViewCSS().getComputedStyle(element, pseudo));
        }
        return this.declarationsCache.get(element);
    }

    public void reset() {
        this.resetCache();
        super.reset();
        this.fireStyleSheetChanged();
    }

    protected void reloadStyleSheets() {
    }

    public void resetCache() {
        this.declarationsCache.clear();
        this.styleSheetsList = null;
        this.availableClasses.clear();
    }

    protected void parseStyleSheets() {
        this.reloadStyleSheets();
        for (URL uRL : this.styleSheetURLs) {
            try {
                this.parseStyleSheet(uRL.openStream());
            }
            catch (IOException ex) {
                this.handleExceptions(ex);
            }
        }
        for (StyleSheet styleSheet : this.styleSheets) {
            try {
                if (styleSheet instanceof EmbeddedStyleSheet) {
                    this.parseStyleSheet((EmbeddedStyleSheet)styleSheet);
                    continue;
                }
                if (!(styleSheet instanceof StyleSheetReference)) continue;
                this.parseStyleSheet((StyleSheetReference)styleSheet);
            }
            catch (IOException ex) {
                this.handleExceptions(ex);
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
    }

    private void parseStyleSheet(EmbeddedStyleSheet styleSheet) throws IOException {
        StringReader reader = new StringReader(styleSheet.getContent());
        this.parseStyleSheet(reader);
    }

    protected void parseStyleSheet(StyleSheetReference styleSheet) throws IOException {
        String path = styleSheet.getPath();
        if (path.startsWith("/")) {
            path = "platform:/resource" + path;
        }
        URL url = new URL(path);
        this.parseStyleSheet(url.openStream());
    }

    public CSSParser makeCSSParser() {
        ICSSParserFactory factory = CSSParserFactory.newInstance();
        CSSParser parser = factory.makeCSSParser();
        parser.setSelectorFactory(CSSSelectorFactoryImpl.INSTANCE);
        parser.setConditionFactory(CONDITIONFACTORY_INSTANCE);
        return parser;
    }

    public ViewCSS getViewCSS() {
        return this.viewCSS;
    }

    public void styleSheetChanged(ExtendedCSSEngine owner) {
        this.reset();
    }

    private void fireStyleSheetChanged() {
        for (StyleSheetChangeListener listener : this.styleSheetListeners) {
            listener.styleSheetChanged(this);
        }
    }

    public void addStyleSheetChangeListener(StyleSheetChangeListener listener) {
        this.styleSheetListeners.add(listener);
    }

    public void removeStyleSheetChangedListener(StyleSheetChangeListener listener) {
        this.styleSheetListeners.remove(listener);
    }

    public ExtendedStyleSheetList getAllStylesheets() {
        if (this.styleSheetsList == null) {
            this.parseStyleSheets();
            this.styleSheetsList = new ExtendedStyleSheetList();
            if (this.parent != null) {
                this.styleSheetsList.addAll(this.parent.getAllStylesheets());
            }
            this.styleSheetsList.addAll(this.getDocumentCSS().getStyleSheets());
        }
        return this.styleSheetsList;
    }

    public Object convert(CSSValue value, Object toType, Object context) {
        try {
            return super.convert(value, toType, context);
        }
        catch (Exception ex) {
            return this.convert(value, toType);
        }
    }

    protected Object convert(CSSValue value, Object toType) {
        ICSSValueConverter converter = this.getCSSValueConverter(toType);
        if (converter != null) {
            try {
                return converter.convert(value, (CSSEngine)this, null);
            }
            catch (Exception ex) {
                this.handleExceptions(ex);
            }
        }
        return value;
    }

    public void dispose() {
        this.styleSheetListeners.clear();
        if (this.parent != null) {
            this.parent.removeStyleSheetChangedListener(this);
        }
        this.getElementsContext();
        super.dispose();
    }

    public void notifyChange(Element elementAdapter) {
        this.resetCache();
        DiagramHelper.setNeedsRefresh();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                DiagramHelper.refreshDiagrams();
            }
        });
    }

    public void handleDispose(Object nativeWidget) {
        super.handleWidgetDisposed(nativeWidget);
    }

    public void reapply() {
        this.resetCache();
    }
}

