/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.engine;

import java.io.IOException;
import java.net.URL;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngineImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.WorkspaceCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.ModelStyleSheets;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.w3c.dom.Element;

public class ModelCSSEngine
extends ExtendedCSSEngineImpl {
    private final Resource model;

    public ModelCSSEngine(Resource model) {
        super(WorkspaceCSSEngine.instance);
        this.model = model;
    }

    protected void reloadStyleSheets() {
        this.styleSheets.clear();
        for (EObject eObject : this.model.getContents()) {
            if (!(eObject instanceof ModelStyleSheets)) continue;
            ModelStyleSheets styleSheets = (ModelStyleSheets)eObject;
            for (StyleSheet styleSheet : styleSheets.getStylesheets()) {
                this.styleSheets.add(styleSheet);
            }
        }
    }

    protected void parseStyleSheet(StyleSheetReference styleSheet) throws IOException {
        String path = styleSheet.getPath();
        if (path.startsWith("/")) {
            path = "platform:/plugin" + path;
        } else {
            URI uri = URI.createURI((String)styleSheet.getPath());
            uri = uri.resolve(this.model.getURI());
            path = uri.toString();
        }
        URL url = new URL(path);
        this.parseStyleSheet(url.openStream());
    }

    public Element getElement(Object node) {
        throw new UnsupportedOperationException();
    }

    public IElementProvider getElementProvider() {
        throw new UnsupportedOperationException();
    }

    public void setElementProvider(IElementProvider elementProvider) {
        throw new UnsupportedOperationException();
    }

    public CSSElementContext getCSSElementContext(Object node) {
        throw new UnsupportedOperationException();
    }
}

