/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.handler;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;

public class ResetStyleHandler
extends AbstractHandler {
    private static Set<String> papyrusStyleAnnotations = new HashSet<String>();

    static {
        papyrusStyleAnnotations.add("displayNameLabelIcon");
        papyrusStyleAnnotations.add("ShadowFigure");
        papyrusStyleAnnotations.add("QualifiedName");
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        try {
            IMultiDiagramEditor editor = (IMultiDiagramEditor)ServiceUtilsForActionHandlers.getInstance().getServiceRegistry().getService(IMultiDiagramEditor.class);
            selection = editor.getEditorSite().getSelectionProvider().getSelection();
        }
        catch (ServiceException ex) {
            throw new ExecutionException(ex.getMessage(), (Throwable)ex);
        }
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        Iterator iterator = sSelection.iterator();
        TransactionalEditingDomain domain = null;
        while (iterator.hasNext()) {
            Object selectedItem = iterator.next();
            View view = NotationHelper.findView(selectedItem);
            if (view == null) continue;
            EditingDomain editingDomain = EMFHelper.resolveEditingDomain((EObject)view);
            if (!(editingDomain instanceof TransactionalEditingDomain)) break;
            domain = (TransactionalEditingDomain)editingDomain;
            break;
        }
        if (domain == null) {
            return null;
        }
        ResetStyleCommand command = new ResetStyleCommand(domain, sSelection);
        domain.getCommandStack().execute((Command)command);
        return null;
    }

    private class ResetStyleCommand
    extends RecordingCommand {
        private IStructuredSelection selection;

        public ResetStyleCommand(TransactionalEditingDomain domain, IStructuredSelection selection) {
            super(domain);
            this.selection = selection;
        }

        public void doExecute() {
            for (Object selectedItem : this.selection) {
                View view = NotationHelper.findView(selectedItem);
                if (view == null) continue;
                if (view instanceof Diagram) {
                    this.resetDiagram((Diagram)view);
                    break;
                }
                this.resetStyle(view);
            }
        }

        private void resetDiagram(Diagram diagram) {
            for (Object viewObject : diagram.getChildren()) {
                if (!(viewObject instanceof View)) continue;
                this.resetStyle((View)viewObject, true);
            }
            for (Object lineObject : diagram.getEdges()) {
                if (!(lineObject instanceof View)) continue;
                this.resetStyle((View)lineObject, true);
            }
        }

        private void resetStyle(View view, boolean recursive) {
            this.resetStyle(view);
            if (recursive) {
                for (Object childObject : view.getChildren()) {
                    if (!(childObject instanceof View)) continue;
                    this.resetStyle((View)childObject, recursive);
                }
            }
        }

        private void resetStyle(View view) {
            for (Object styleObject : view.getStyles()) {
                if (!(styleObject instanceof Style)) continue;
                this.resetStyle((Style)styleObject);
            }
            if (view instanceof Style) {
                this.resetStyle((Style)view);
            }
            this.resetAnnotations(view);
            this.resetStyleAnnotations(view);
        }

        private void resetStyle(Style style) {
            if (style instanceof NamedStyle) {
                return;
            }
            for (EStructuralFeature feature : style.eClass().getEAllStructuralFeatures()) {
                if (!NotationPackage.eINSTANCE.getStyle().isSuperTypeOf(feature.getEContainingClass())) continue;
                style.eUnset(feature);
            }
        }

        private void resetAnnotations(View view) {
            Iterator iterator = view.getEAnnotations().iterator();
            while (iterator.hasNext()) {
                if (!"PapyrusCSSForceValue".equals(((EAnnotation)iterator.next()).getSource())) continue;
                iterator.remove();
            }
        }

        private void resetStyleAnnotations(View view) {
            Iterator iterator = view.getEAnnotations().iterator();
            while (iterator.hasNext()) {
                if (!papyrusStyleAnnotations.contains(((EAnnotation)iterator.next()).getSource())) continue;
                iterator.remove();
            }
        }
    }
}

