/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.preferences;

import java.util.List;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.WorkspaceCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.theme.Theme;
import org.eclipse.papyrus.infra.gmfdiag.css.theme.ThemeManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ThemePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public boolean needsRefresh = false;

    public ThemePreferencesPage() {
        super("CSS Theme", org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImageDescriptor("/icons/papyrus.png"), 0);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Papyrus Theme preferences");
    }

    protected void createFieldEditors() {
        String[][] themes = this.getFieldThemes();
        ComboFieldEditor editor = new ComboFieldEditor("currentTheme", "Current theme:", themes, this.getFieldEditorParent());
        this.addField((FieldEditor)editor);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if ("currentTheme".equals(event.getProperty())) {
            this.needsRefresh = true;
        }
        if ("field_editor_value".equals(event.getProperty()) && "currentTheme".equals(((FieldEditor)event.getSource()).getPreferenceName())) {
            this.needsRefresh = true;
        }
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (this.needsRefresh) {
            WorkspaceCSSEngine.instance.reset();
            DiagramHelper.setNeedsRefresh();
            DiagramHelper.refreshDiagrams();
        }
        return result;
    }

    protected String[][] getFieldThemes() {
        List<Theme> themes = ThemeManager.instance.getThemes();
        String[][] result = new String[themes.size()][2];
        int i = 0;
        for (Theme theme : themes) {
            result[i][0] = theme.getLabel();
            result[i][1] = theme.getId();
            ++i;
        }
        return result;
    }
}

