/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.service;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.service.IMarkerToPseudoSelectorMappingProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerToPseudoSelectorMappingService
implements IService {
    protected ServicesRegistry servicesRegistry;
    protected Map<String, String> markerToPseudoSelectorMap;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.servicesRegistry = servicesRegistry;
        this.markerToPseudoSelectorMap = this.getRegisteredMarkerToPseudoSelectorsMappingProviders();
    }

    public void startService() throws ServiceException {
    }

    public void disposeService() throws ServiceException {
    }

    public String getPseudoSelector(String markerKind) {
        String pseudoSelector = this.markerToPseudoSelectorMap.get(markerKind);
        return pseudoSelector != null ? pseudoSelector : "";
    }

    protected Map<String, String> getRegisteredMarkerToPseudoSelectorsMappingProviders() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] config = registry.getConfigurationElementsFor("org.eclipse.papyrus.infra.gmfdiag.css.markertopseudoselectormappingprovider");
        HashMap<String, String> providers = new HashMap<String, String>();
        int i = 0;
        while (i < config.length) {
            try {
                IMarkerToPseudoSelectorMappingProvider provider = (IMarkerToPseudoSelectorMappingProvider)config[i].createExecutableExtension("class");
                Map<String, String> mappings = provider.getMappings();
                for (String markerKind : mappings.keySet()) {
                    if (providers.containsKey(markerKind)) {
                        Activator.log.warn("Multiple pseudo selectors registered for " + markerKind);
                    }
                    providers.put(markerKind, mappings.get(markerKind));
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            ++i;
        }
        return providers;
    }
}

