/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.style.impl;

import org.eclipse.gmf.runtime.notation.DiagramStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.style.CSSDiagramStyle;
import org.w3c.dom.css.CSSValue;

public class CSSDiagramStyleDelegate
implements CSSDiagramStyle {
    private DiagramStyle diagramStyle;
    private ExtendedCSSEngine engine;

    public CSSDiagramStyleDelegate(DiagramStyle diagramStyle, ExtendedCSSEngine engine) {
        this.diagramStyle = diagramStyle;
        this.engine = engine;
    }

    public int getCSSPageX() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.diagramStyle, "pageX");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getPageStyle_PageX().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }

    public int getCSSPageY() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.diagramStyle, "pageY");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getPageStyle_PageY().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }

    public int getCSSPageWidth() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.diagramStyle, "pageWidth");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getPageStyle_PageWidth().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }

    public int getCSSPageHeight() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.diagramStyle, "pageHeight");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getPageStyle_PageHeight().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }

    public String getCSSDescription() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.diagramStyle, "description");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getDescriptionStyle_Description().getDefaultValue();
            return (String)defaultValue;
        }
        return (String)this.engine.convert(cssValue, String.class, null);
    }
}

