/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.style.impl;

import org.eclipse.gmf.runtime.notation.JumpLinkStatus;
import org.eclipse.gmf.runtime.notation.JumpLinkType;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.Smoothness;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.style.CSSRoutingStyle;
import org.w3c.dom.css.CSSValue;

public class CSSRoutingStyleDelegate
implements CSSRoutingStyle {
    private RoutingStyle routingStyle;
    private ExtendedCSSEngine engine;

    public CSSRoutingStyleDelegate(RoutingStyle routingStyle, ExtendedCSSEngine engine) {
        this.routingStyle = routingStyle;
        this.engine = engine;
    }

    public int getCSSRoundedBendpointsRadius() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.routingStyle, "roundedBendpointsRadius");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getRoundedCornersStyle_RoundedBendpointsRadius().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }

    public Routing getCSSRouting() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.routingStyle, "routing");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getRoutingStyle_Routing().getDefaultValue();
            return (Routing)defaultValue;
        }
        return Routing.get((String)cssValue.getCssText());
    }

    public Smoothness getCSSSmoothness() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.routingStyle, "smoothness");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getRoutingStyle_Smoothness().getDefaultValue();
            return (Smoothness)defaultValue;
        }
        return Smoothness.get((String)cssValue.getCssText());
    }

    public boolean isCSSAvoidObstructions() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.routingStyle, "avoidObstructions");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getRoutingStyle_AvoidObstructions().getDefaultValue();
            return (Boolean)defaultValue;
        }
        return (Boolean)this.engine.convert(cssValue, Boolean.class, null);
    }

    public boolean isCSSClosestDistance() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.routingStyle, "closestDistance");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getRoutingStyle_ClosestDistance().getDefaultValue();
            return (Boolean)defaultValue;
        }
        return (Boolean)this.engine.convert(cssValue, Boolean.class, null);
    }

    public JumpLinkStatus getCSSJumpLinkStatus() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.routingStyle, "jumpLinkStatus");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getRoutingStyle_JumpLinkStatus().getDefaultValue();
            return (JumpLinkStatus)defaultValue;
        }
        return JumpLinkStatus.get((String)cssValue.getCssText());
    }

    public JumpLinkType getCSSJumpLinkType() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.routingStyle, "jumpLinkType");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getRoutingStyle_JumpLinkType().getDefaultValue();
            return (JumpLinkType)defaultValue;
        }
        return JumpLinkType.get((String)cssValue.getCssText());
    }

    public boolean isCSSJumpLinksReverse() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.routingStyle, "jumpLinksReverse");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getRoutingStyle_JumpLinksReverse().getDefaultValue();
            return (Boolean)defaultValue;
        }
        return (Boolean)this.engine.convert(cssValue, Boolean.class, null);
    }
}

