/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.uml.diagram.internal.ui.wizards;

import com.google.common.base.Supplier;
import com.google.common.eventbus.EventBus;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.core.IPapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.uml.diagram.internal.ui.wizards.NewModelPage;
import org.eclipse.papyrus.cdo.uml.diagram.internal.ui.wizards.RepositorySelectionPart;
import org.eclipse.papyrus.uml.diagram.wizards.AbstractNewModelStorageProvider;
import org.eclipse.papyrus.uml.diagram.wizards.CreateModelWizard;
import org.eclipse.papyrus.uml.diagram.wizards.INewModelStorageProvider;
import org.eclipse.papyrus.uml.diagram.wizards.InitModelWizard;
import org.eclipse.papyrus.uml.diagram.wizards.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.utils.WizardsHelper;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDONewModelStorageProvider
extends AbstractNewModelStorageProvider {
    private final EventBus bus = new EventBus("NewCDOModelWizard");
    private CreateModelWizard wizard;
    private RepositorySelectionPart selectProviderPart;
    private NewModelPage newModelPage;

    public boolean canHandle(IStructuredSelection initialSelection) {
        boolean result = false;
        for (Object next : initialSelection.toList()) {
            if (!CDOUtils.isCDOObject((EObject)((EObject)WizardsHelper.adapt(next, EObject.class)))) continue;
            result = true;
            break;
        }
        return result;
    }

    public void init(CreateModelWizard wizard, IStructuredSelection selection) {
        super.init(wizard, selection);
        this.wizard = wizard;
        this.newModelPage = this.createNewModelPage(selection);
        this.createSelectProviderPart();
        IPapyrusRepository repo = CDONewModelStorageProvider.getRepository(selection);
        if (repo != null) {
            this.bus.post((Object)repo);
        }
    }

    static IPapyrusRepository getRepository(IStructuredSelection selection) {
        IPapyrusRepository result = null;
        if (!selection.isEmpty() && (result = (IPapyrusRepository)WizardsHelper.adapt((Object)selection.getFirstElement(), IPapyrusRepository.class)) == null) {
            CDOObject cdo;
            EObject object;
            CDOResourceNode node = (CDOResourceNode)WizardsHelper.adapt((Object)selection.getFirstElement(), CDOResourceNode.class);
            if (node == null && (object = (EObject)WizardsHelper.adapt((Object)selection.getFirstElement(), EObject.class)) != null && (cdo = CDOUtils.getCDOObject((EObject)object)) != null) {
                node = cdo.cdoResource();
            }
            if (node != null) {
                result = PapyrusRepositoryManager.INSTANCE.getRepositoryForURI(node.getURI());
            }
        }
        return result;
    }

    public List<? extends IWizardPage> createPages() {
        if (this.newModelPage == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.newModelPage);
    }

    public IStatus validateDiagramCategories(String ... newCategories) {
        if (this.newModelPage != null) {
            String firstCategory;
            String string = firstCategory = newCategories.length > 0 ? newCategories[0] : null;
            if (newCategories.length > 0) {
                return this.newModelPage.diagramExtensionChanged(this.wizard.getDiagramFileExtension(firstCategory));
            }
        }
        return super.validateDiagramCategories(newCategories);
    }

    protected NewModelPage createNewModelPage(IStructuredSelection selection) {
        if (this.wizard.isCreateProjectWizard() || this.wizard.isCreateMultipleModelsWizard()) {
            return null;
        }
        if (this.isCreateFromExistingDomainModel()) {
            URI uri = WizardsHelper.getSelectedResourceURI((IStructuredSelection)selection).trimFileExtension().appendFileExtension(this.wizard.getDiagramFileExtension(null));
            return new NewDiagramForExistingModelPage(selection, this.wizard.getModelKindName(), this.bus, uri.lastSegment());
        }
        return new NewModelPage(selection, this.bus, this.wizard.getModelKindName());
    }

    protected boolean isCreateFromExistingDomainModel() {
        return this.wizard.isInitModelWizard() && ((InitModelWizard)this.wizard).isCreateFromExistingDomainModel();
    }

    public URI createNewModelURI(String categoryId) {
        return this.newModelPage.createNewModelResourceURI();
    }

    public INewModelStorageProvider.ISelectProviderPart createSelectProviderPart() {
        if (this.selectProviderPart == null) {
            this.selectProviderPart = new RepositorySelectionPart((IPapyrusRepositoryManager)PapyrusRepositoryManager.INSTANCE, this.bus, (Supplier<? extends IRunnableContext>)new Supplier<IRunnableContext>(){

                public IRunnableContext get() {
                    return CDONewModelStorageProvider.this.wizard.getContainer();
                }
            });
        }
        return this.selectProviderPart;
    }

    protected static class NewDiagramForExistingModelPage
    extends NewModelPage {
        private final String myDiagramResourceName;

        public NewDiagramForExistingModelPage(IStructuredSelection selection, String modelKindName, EventBus bus, String defaultResourceName) {
            super(selection, bus, modelKindName);
            this.myDiagramResourceName = defaultResourceName;
            this.setTitle(Messages.InitModelWizard_init_papyrus_model);
            this.setDescription(Messages.InitModelWizard_init_papyrus_model_desc);
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.setNewResourceName(this.myDiagramResourceName);
        }

        protected void validatePage() {
            super.validatePage();
            if (this.getMessageType() < 3 && !this.myDiagramResourceName.equals(this.getNewResourceName())) {
                this.setMessage(Messages.bind((String)Messages.InitModelWizard_diagram_name_is_different_from_domain_model, (Object)this.myDiagramResourceName), 3);
                this.setPageComplete(false);
            }
        }
    }
}

