/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.uml.diagram.internal.ui.wizards;

import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.ui.views.ModelRepositoryItemProvider;
import org.eclipse.papyrus.cdo.uml.diagram.internal.ui.l10n.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.utils.WizardsHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewModelPage
extends WizardPage {
    public static final String PAGE_ID = "NewCDOModel";
    private Text folderText;
    private TreeViewer foldersTree;
    private Text nameText;
    private IPapyrusRepository repository;
    private CDOResourceNode selectedNode;
    private boolean synchronizingFolderSelection;

    public NewModelPage(IStructuredSelection selection, EventBus bus, String modelKindName) {
        super(PAGE_ID);
        this.setTitle(NLS.bind((String)Messages.NewModelPage_0, (Object)modelKindName));
        this.setDescription(NLS.bind((String)Messages.NewModelPage_1, (Object)modelKindName));
        if (!selection.isEmpty()) {
            this.selectedNode = (CDOResourceNode)WizardsHelper.adapt((Object)selection.getFirstElement(), CDOResourceNode.class);
            if (this.selectedNode != null && !(this.selectedNode instanceof CDOResourceFolder)) {
                this.selectedNode = this.selectedNode.getFolder();
            }
        }
        bus.register((Object)this);
    }

    public void createControl(Composite parent) {
        Composite myComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)myComposite);
        myComposite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(myComposite, 0);
        label.setText(Messages.NewModelPage_2);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)label);
        this.folderText = new Text(myComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.folderText);
        this.updateFolderSelection();
        this.foldersTree = new TreeViewer(myComposite, 2816);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo(this.foldersTree.getControl());
        ModelRepositoryItemProvider itemProvider = new ModelRepositoryItemProvider(null);
        this.foldersTree.setContentProvider((IContentProvider)itemProvider);
        this.foldersTree.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)itemProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.foldersTree.setSorter((ViewerSorter)itemProvider);
        if (this.getRepository() != null) {
            this.foldersTree.setInput((Object)this.getRepository());
        }
        if (this.selectedNode != null) {
            this.foldersTree.setSelection((ISelection)new StructuredSelection((Object)this.selectedNode));
        }
        new Label(myComposite, 0).setText(Messages.NewModelPage_3);
        this.nameText = new Text(myComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameText);
        this.nameText.setText(this.suggestName("model", "di"));
        this.setControl((Control)myComposite);
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewModelPage.this.findFolderSelection();
                NewModelPage.this.validatePage();
            }
        });
        this.foldersTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                NewModelPage.this.selectedNode = selection.isEmpty() ? null : (CDOResourceNode)WizardsHelper.adapt((Object)selection.getFirstElement(), CDOResourceNode.class);
                NewModelPage.this.updateFolderSelection();
                NewModelPage.this.validatePage();
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewModelPage.this.validatePage();
            }
        });
        this.validatePage();
    }

    @Subscribe
    public void setRepository(IPapyrusRepository repository) {
        this.repository = repository;
        if (this.foldersTree != null) {
            this.foldersTree.setInput((Object)repository);
        }
        this.validatePage();
    }

    private IInternalPapyrusRepository getRepository() {
        return (IInternalPapyrusRepository)this.repository;
    }

    CDOView getView() {
        IInternalPapyrusRepository repo = this.getRepository();
        return repo == null ? null : repo.getMasterView();
    }

    String getSelectedFolderPath() {
        return this.folderText.getText().trim();
    }

    void updateFolderSelection() {
        this.whileSynchronizingFolderSelection(new Runnable(){

            public void run() {
                CDOResourceFolder selected = null;
                if (NewModelPage.this.selectedNode instanceof CDOResourceFolder) {
                    selected = (CDOResourceFolder)NewModelPage.this.selectedNode;
                } else if (NewModelPage.this.selectedNode != null) {
                    selected = NewModelPage.this.selectedNode.getFolder();
                }
                if (selected == null) {
                    NewModelPage.this.folderText.setText("");
                } else {
                    NewModelPage.this.folderText.setText(selected.getPath());
                }
            }
        });
    }

    void findFolderSelection() {
        this.whileSynchronizingFolderSelection(new Runnable(){

            public void run() {
                String folder = NewModelPage.this.folderText.getText().trim();
                CDOView view = NewModelPage.this.getView();
                if (view != null) {
                    if (folder.equals("")) {
                        NewModelPage.this.foldersTree.setSelection((ISelection)StructuredSelection.EMPTY);
                    } else {
                        try {
                            NewModelPage.this.foldersTree.setSelection((ISelection)new StructuredSelection((Object)view.getResourceNode(folder)));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    private void whileSynchronizingFolderSelection(Runnable runnable) {
        if (!this.synchronizingFolderSelection) {
            this.synchronizingFolderSelection = true;
            try {
                runnable.run();
            }
            finally {
                this.synchronizingFolderSelection = false;
            }
        }
    }

    String suggestName(String baseName, String extension) {
        String result = String.format("%s.%s", baseName, extension);
        CDOView view = this.getView();
        if (view != null) {
            int i = 1;
            while (view.hasResource(this.getNewResourcePath(result))) {
                result = String.format("%s%s.%s", baseName, i, extension);
                ++i;
            }
        }
        return result;
    }

    String getNewResourcePath(String name) {
        String result = null;
        String path = this.getSelectedFolderPath();
        if (path.equals("")) {
            result = "/" + name;
        } else {
            StringBuilder buf = new StringBuilder();
            if (!path.startsWith("/")) {
                buf.append("/");
            }
            buf.append(path);
            if (!path.endsWith("/")) {
                buf.append("/");
            }
            buf.append(name);
            result = buf.toString();
        }
        return result;
    }

    String getNewResourceName() {
        return this.nameText == null ? null : this.nameText.getText().trim();
    }

    void setNewResourceName(String newName) {
        this.nameText.setText(newName.trim());
    }

    public URI createNewModelResourceURI() {
        return CDOURIUtil.createResourceURI((CDOView)this.getView(), (String)this.getNewResourcePath(this.getNewResourceName()));
    }

    private String getExtension() {
        int dot;
        String result = null;
        String name = this.getNewResourceName();
        if (name != null && (dot = name.indexOf(46)) >= 0) {
            result = name.substring(dot + 1);
        }
        return result;
    }

    public IStatus diagramExtensionChanged(String newExtension) {
        String currentExtension = this.getExtension();
        if (!newExtension.equals(currentExtension)) {
            String oldFileName;
            String base = oldFileName = this.getNewResourceName();
            if (currentExtension != null) {
                base = base.substring(0, base.length() - currentExtension.length() - 1);
            }
            String newFileName = this.suggestName(base, newExtension);
            this.setNewResourceName(newFileName);
            String message1 = org.eclipse.papyrus.uml.diagram.wizards.Messages.NewModelFilePage_new_diagram_category_needs_specific_extension;
            String message2 = org.eclipse.papyrus.uml.diagram.wizards.Messages.bind((String)org.eclipse.papyrus.uml.diagram.wizards.Messages.NewModelFilePage_diagram_file_was_renamed, (Object)oldFileName, (Object)newFileName);
            String message = String.valueOf(message1) + message2;
            Status resultStatus = new Status(1, "org.eclipse.papyrus.uml.diagram.wizards", message);
            String errorMessage = this.getErrorMessage();
            if (errorMessage != null) {
                resultStatus = new Status(4, "org.eclipse.papyrus.uml.diagram.wizards", errorMessage);
            }
            return resultStatus;
        }
        return Status.OK_STATUS;
    }

    void validatePage() {
        this.setMessage(null, 0);
        this.setPageComplete(true);
        String name = this.getNewResourceName();
        if (this.getView() == null) {
            this.setMessage(Messages.NewModelPage_16, 3);
            this.setPageComplete(false);
        } else if (Strings.isNullOrEmpty((String)name)) {
            this.setMessage(Messages.NewModelPage_17, 3);
            this.setPageComplete(false);
        } else {
            String path = this.getNewResourcePath(name);
            if (this.getView().hasResource(path)) {
                this.setMessage(NLS.bind((String)Messages.NewModelPage_18, (Object)path), 3);
                this.setPageComplete(false);
            } else {
                String folderPath = this.getSelectedFolderPath();
                if (!Strings.isNullOrEmpty((String)folderPath) && !this.getView().hasResource(folderPath)) {
                    this.setMessage(Messages.NewModelPage_19, 2);
                }
            }
        }
    }
}

