/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.uml.diagram.internal.ui.wizards;

import com.google.common.base.Supplier;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.core.IPapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.wizards.RepositorySelectionBlock;
import org.eclipse.papyrus.uml.diagram.wizards.AbstractSelectStorageProviderPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositorySelectionPart
extends AbstractSelectStorageProviderPart {
    private final IPapyrusRepositoryManager repoMan;
    private final Supplier<? extends IRunnableContext> runnableContext;
    private final EventBus bus;
    private RepositorySelectionBlock repoSelectionBlock;

    public RepositorySelectionPart(IPapyrusRepositoryManager repoMan, EventBus bus, Supplier<? extends IRunnableContext> runnableContext) {
        this.repoMan = repoMan;
        this.runnableContext = runnableContext;
        this.bus = bus;
    }

    public Control createControl(Composite parent) {
        this.bus.register((Object)this);
        this.repoSelectionBlock = new RepositorySelectionBlock(this.repoMan, this.bus, this.runnableContext);
        return this.repoSelectionBlock.createControl(parent);
    }

    protected void enableControls(boolean enabled) {
        this.repoSelectionBlock.setEnabled(enabled);
    }

    public IPapyrusRepository getSelectedRepository() {
        return this.repoSelectionBlock == null ? null : this.repoSelectionBlock.getSelectedRepository();
    }

    @Subscribe
    public void setSelectedRepository(IPapyrusRepository repository) {
        this.firePartCompleteChanged();
    }

    public boolean isPartComplete() {
        return this.getSelectedRepository() != null && this.getSelectedRepository().isConnected();
    }
}

