/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.project;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.papyrus.eclipse.project.editors.file.ManifestEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IEMFFacetProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IManifestEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IPluginProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.JavaProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.PluginProjectEditor;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFFacetProjectEditor
extends JavaProjectEditor
implements IEMFFacetProjectEditor {
    private final IPluginProjectEditor pluginEditor;
    private final IManifestEditor manifestEditor;

    @Override
    public IPluginProjectEditor getPluginEditor() {
        return this.pluginEditor;
    }

    @Override
    public IManifestEditor getManifestEditor() {
        return this.manifestEditor;
    }

    public EMFFacetProjectEditor(IProject project) throws IOException, CoreException, ParserConfigurationException, SAXException {
        super(project);
        this.pluginEditor = new PluginProjectEditor(project);
        this.manifestEditor = new ManifestEditor(project);
    }

    @Override
    public Set<String> getMissingNature() {
        Set<String> natures = super.getMissingNature();
        natures.addAll(this.pluginEditor.getMissingNature());
        if (!this.hasNature("org.eclipse.emf.facet.common.ProjectNature")) {
            natures.add("org.eclipse.emf.facet.common.ProjectNature");
        }
        return natures;
    }

    @Override
    public void init() {
        super.init();
        this.manifestEditor.init();
        this.pluginEditor.init();
    }

    @Override
    public Set<String> getMissingFiles() {
        Set<String> files = super.getMissingFiles();
        files.addAll(this.pluginEditor.getMissingFiles());
        files.addAll(this.manifestEditor.getMissingFiles());
        return files;
    }

    @Override
    public void registerFacetSets(List<FacetSet> facetSets) {
        int i = 0;
        while (i < facetSets.size()) {
            FacetSet set = facetSets.get(i);
            URI uri = set.eResource().getURI();
            IPath projectLocation = this.getProject().getLocation();
            String filepath = uri.devicePath();
            String projectPath = projectLocation.toOSString();
            if ((filepath = filepath.substring(projectPath.length())).charAt(0) == '/') {
                filepath = filepath.substring(1);
            }
            boolean registered = false;
            List<Node> extensions = this.pluginEditor.getExtensions("org.eclipse.emf.facet.infra.facet.registration");
            if (extensions != null) {
                for (Node current : extensions) {
                    NamedNodeMap attributes;
                    Node node;
                    Node child = current.getFirstChild();
                    if (child == null || (node = (attributes = child.getAttributes()).getNamedItem("file")) == null) continue;
                    String path = node.getNodeValue();
                    registered = filepath.equals(path);
                }
            }
            if (!registered) {
                Element extension = this.pluginEditor.addExtension("org.eclipse.emf.facet.infra.facet.registration");
                Element facetSet = this.pluginEditor.addChild(extension, "facetset");
                this.pluginEditor.setAttribute(facetSet, "file", filepath);
            }
            ++i;
        }
    }

    @Override
    public void registerQuerySets(List<EObject> querySets) {
        int i = 0;
        while (i < querySets.size()) {
            URI uri = querySets.get(i).eResource().getURI();
            IPath projectLocation = this.getProject().getLocation();
            String filepath = uri.devicePath();
            String projectPath = projectLocation.toOSString();
            if ((filepath = filepath.substring(projectPath.length())).charAt(0) == '/') {
                filepath = filepath.substring(1);
            }
            boolean registered = false;
            List<Node> extensions = this.pluginEditor.getExtensions("org.eclipse.emf.facet.infra.query.registration");
            if (extensions != null) {
                Iterator<Node> iter = extensions.iterator();
                while (iter.hasNext() && !registered) {
                    NamedNodeMap attributes;
                    Node node;
                    Node current = iter.next();
                    Node child = current.getFirstChild();
                    if (child == null || (node = (attributes = child.getAttributes()).getNamedItem("file")) == null) continue;
                    String path = node.getNodeValue();
                    registered = filepath.equals(path);
                }
            }
            if (!registered) {
                Element extension = this.pluginEditor.addExtension("org.eclipse.emf.facet.infra.query.registration");
                Element querySet = this.pluginEditor.addChild(extension, "modelqueryset");
                this.pluginEditor.setAttribute(querySet, "file", filepath);
            }
            ++i;
        }
    }

    @Override
    public void addDependency(String dependency) {
        this.manifestEditor.addDependency(dependency);
    }

    @Override
    public void save() {
        this.pluginEditor.save();
        this.manifestEditor.save();
        super.save();
    }

    @Override
    public void addDependency(String dependency, String version) {
        this.manifestEditor.addDependency(dependency, version);
    }

    @Override
    public void create() {
        super.create();
        this.pluginEditor.create();
        this.manifestEditor.create();
    }

    @Override
    public void createFiles(Set<String> files) {
        this.pluginEditor.createFiles(files);
        this.manifestEditor.createFiles(files);
        super.createFiles(files);
    }

    @Override
    public Set<String> getMissingBuildCommand() {
        Set<String> buildCommand = super.getMissingBuildCommand();
        buildCommand.addAll(this.pluginEditor.getMissingBuildCommand());
        if (!this.hasBuildCommand("org.eclipse.pde.ManifestBuilder")) {
            buildCommand.add("org.eclipse.pde.ManifestBuilder");
        }
        if (!this.hasBuildCommand("org.eclipse.emf.facet.common.core.builder")) {
            buildCommand.add("org.eclipse.emf.facet.common.core.builder");
        }
        return buildCommand;
    }
}

