/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.dependability;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SeverityClassKind implements Enumerator
{
    S0(0, "S0", "S0"),
    S1(1, "S1", "S1"),
    S2(2, "S2", "S2"),
    S3(3, "S3", "S3");

    public static final int S0_VALUE = 0;
    public static final int S1_VALUE = 1;
    public static final int S2_VALUE = 2;
    public static final int S3_VALUE = 3;
    private static final SeverityClassKind[] VALUES_ARRAY;
    public static final List<SeverityClassKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SeverityClassKind[]{S0, S1, S2, S3};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SeverityClassKind get(int value) {
        switch (value) {
            case 0: {
                return S0;
            }
            case 1: {
                return S1;
            }
            case 2: {
                return S2;
            }
            case 3: {
                return S3;
            }
        }
        return null;
    }

    public static SeverityClassKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SeverityClassKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SeverityClassKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SeverityClassKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private SeverityClassKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

