/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.dependability.errormodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ErrorBehaviorKind implements Enumerator
{
    HIP_HOPS(0, "HIP_HOPS", "HIP_HOPS"),
    ALTARICA(1, "ALTARICA", "ALTARICA"),
    AADL(2, "AADL", "AADL"),
    OTHER(3, "OTHER", "OTHER");

    public static final int HIP_HOPS_VALUE = 0;
    public static final int ALTARICA_VALUE = 1;
    public static final int AADL_VALUE = 2;
    public static final int OTHER_VALUE = 3;
    private static final ErrorBehaviorKind[] VALUES_ARRAY;
    public static final List<ErrorBehaviorKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ErrorBehaviorKind[]{HIP_HOPS, ALTARICA, AADL, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ErrorBehaviorKind get(int value) {
        switch (value) {
            case 0: {
                return HIP_HOPS;
            }
            case 1: {
                return ALTARICA;
            }
            case 2: {
                return AADL;
            }
            case 3: {
                return OTHER;
            }
        }
        return null;
    }

    public static ErrorBehaviorKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ErrorBehaviorKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ErrorBehaviorKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ErrorBehaviorKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private ErrorBehaviorKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

