/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.genericconstraints;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GenericConstraintKind implements Enumerator
{
    POWER_CONSUMPTION(0, "powerConsumption", "powerConsumption"),
    OTHER(1, "other", "other"),
    PIECE_COST(2, "pieceCost", "pieceCost"),
    WEIGHT(3, "weight", "weight"),
    STANDARD(4, "standard", "standard"),
    CABLE_LENGTH(5, "cableLength", "cableLength"),
    DEVELOPMENT_COST(6, "developmentCost", "developmentCost"),
    FUNCTION_ALLOCATION_DIFFERENT_NODES(7, "functionAllocationDifferentNodes", "functionAllocationDifferentNodes"),
    FUNCTION_ALLOCATION_SAME_NODE(8, "functionAllocationSameNode", "functionAllocationSameNode"),
    POWER_SUPPLY_INDEPENDENT(9, "powerSupplyIndependent", "powerSupplyIndependent");

    public static final int POWER_CONSUMPTION_VALUE = 0;
    public static final int OTHER_VALUE = 1;
    public static final int PIECE_COST_VALUE = 2;
    public static final int WEIGHT_VALUE = 3;
    public static final int STANDARD_VALUE = 4;
    public static final int CABLE_LENGTH_VALUE = 5;
    public static final int DEVELOPMENT_COST_VALUE = 6;
    public static final int FUNCTION_ALLOCATION_DIFFERENT_NODES_VALUE = 7;
    public static final int FUNCTION_ALLOCATION_SAME_NODE_VALUE = 8;
    public static final int POWER_SUPPLY_INDEPENDENT_VALUE = 9;
    private static final GenericConstraintKind[] VALUES_ARRAY;
    public static final List<GenericConstraintKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GenericConstraintKind[]{POWER_CONSUMPTION, OTHER, PIECE_COST, WEIGHT, STANDARD, CABLE_LENGTH, DEVELOPMENT_COST, FUNCTION_ALLOCATION_DIFFERENT_NODES, FUNCTION_ALLOCATION_SAME_NODE, POWER_SUPPLY_INDEPENDENT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GenericConstraintKind get(int value) {
        switch (value) {
            case 0: {
                return POWER_CONSUMPTION;
            }
            case 1: {
                return OTHER;
            }
            case 2: {
                return PIECE_COST;
            }
            case 3: {
                return WEIGHT;
            }
            case 4: {
                return STANDARD;
            }
            case 5: {
                return CABLE_LENGTH;
            }
            case 6: {
                return DEVELOPMENT_COST;
            }
            case 7: {
                return FUNCTION_ALLOCATION_DIFFERENT_NODES;
            }
            case 8: {
                return FUNCTION_ALLOCATION_SAME_NODE;
            }
            case 9: {
                return POWER_SUPPLY_INDEPENDENT;
            }
        }
        return null;
    }

    public static GenericConstraintKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GenericConstraintKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GenericConstraintKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GenericConstraintKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private GenericConstraintKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

