/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.structure.hardwaremodeling;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HardwarePinDirectionKind implements Enumerator
{
    IN(0, "in", "in"),
    INOUT(1, "inout", "inout"),
    OUT(2, "out", "out");

    public static final int IN_VALUE = 0;
    public static final int INOUT_VALUE = 1;
    public static final int OUT_VALUE = 2;
    private static final HardwarePinDirectionKind[] VALUES_ARRAY;
    public static final List<HardwarePinDirectionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HardwarePinDirectionKind[]{IN, INOUT, OUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HardwarePinDirectionKind get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return INOUT;
            }
            case 2: {
                return OUT;
            }
        }
        return null;
    }

    public static HardwarePinDirectionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HardwarePinDirectionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HardwarePinDirectionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HardwarePinDirectionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private HardwarePinDirectionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

