/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.structure.hardwaremodeling;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IOHardwarePinKind implements Enumerator
{
    DIGITAL(0, "digital", "digital"),
    ANALOG(1, "analog", "analog"),
    PWM(2, "pwm", "pwm"),
    OTHER(3, "other", "other");

    public static final int DIGITAL_VALUE = 0;
    public static final int ANALOG_VALUE = 1;
    public static final int PWM_VALUE = 2;
    public static final int OTHER_VALUE = 3;
    private static final IOHardwarePinKind[] VALUES_ARRAY;
    public static final List<IOHardwarePinKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IOHardwarePinKind[]{DIGITAL, ANALOG, PWM, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IOHardwarePinKind get(int value) {
        switch (value) {
            case 0: {
                return DIGITAL;
            }
            case 1: {
                return ANALOG;
            }
            case 2: {
                return PWM;
            }
            case 3: {
                return OTHER;
            }
        }
        return null;
    }

    public static IOHardwarePinKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IOHardwarePinKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IOHardwarePinKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IOHardwarePinKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private IOHardwarePinKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

