/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.celleditor.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.nattable.celleditor.config.IAxisCellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class CellEditorConfigurationFactory {
    private Map<Integer, IAxisCellEditorConfiguration> registry;
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.nattable.celleditor.configuration";
    public static final String CELL_EDITOR_CONFIGURATION_CLASS_ATTRIBUTE = "class";
    public static final String ORDER_ATTRIBUTE = "order";
    public static final CellEditorConfigurationFactory INSTANCE = new CellEditorConfigurationFactory();

    private CellEditorConfigurationFactory() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        this.registry = new TreeMap<Integer, IAxisCellEditorConfiguration>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            Integer order = new Integer(iConfigurationElement.getAttribute(ORDER_ATTRIBUTE));
            try {
                IAxisCellEditorConfiguration factory = (IAxisCellEditorConfiguration)iConfigurationElement.createExecutableExtension(CELL_EDITOR_CONFIGURATION_CLASS_ATTRIBUTE);
                if (factory != null) {
                    this.registry.put(order, factory);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            ++n2;
        }
    }

    public IAxisCellEditorConfiguration getCellEditorConfigruation(String configurationId) {
        assert (configurationId != null);
        for (Integer order : this.registry.keySet()) {
            IAxisCellEditorConfiguration current = this.registry.get(order);
            if (!configurationId.equals(current.getEditorId())) continue;
            return current;
        }
        return null;
    }

    public IAxisCellEditorConfiguration getFirstCellEditorConfiguration(Table table, Object obj) {
        List<IAxisCellEditorConfiguration> factories = this.getCellEditorConfigurationFactories(table, obj);
        if (!factories.isEmpty()) {
            return factories.get(0);
        }
        return null;
    }

    public List<IAxisCellEditorConfiguration> getCellEditorConfigurationFactories(Table table, Object obj) {
        ArrayList<IAxisCellEditorConfiguration> factories = new ArrayList<IAxisCellEditorConfiguration>();
        for (IAxisCellEditorConfiguration current : this.registry.values()) {
            if (!current.handles(table, obj)) continue;
            factories.add(current);
        }
        return factories;
    }
}

