/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.configuration;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderCellContextElement;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class CustomizedCellPainter
extends TextPainter {
    public CustomizedCellPainter() {
        super(false, true);
    }

    protected String convertDataType(ILayerCell cell, IConfigRegistry configRegistry) {
        LabelProviderCellContextElement contextElement;
        LabelProviderService serv = (LabelProviderService)configRegistry.getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
        ILabelProvider provider = serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.full.labelprovider", (Object)(contextElement = new LabelProviderCellContextElement(cell, configRegistry)));
        String str = provider.getText((Object)contextElement);
        if (str == null) {
            str = "";
        }
        return str;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        super.paintCell(cell, gc, rectangle, configRegistry);
        IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
        int fontHeight = gc.getFontMetrics().getHeight();
        String text = this.convertDataType(cell, configRegistry);
        text = this.getTextToDisplay(cell, gc, rectangle.width, text);
        int numberOfNewLines = this.getNumberOfNewLines(text);
        int contentHeight = fontHeight * numberOfNewLines + this.spacing * 2;
        int contentToCellDiff = cell.getBounds().height - rectangle.height;
        if (this.performRowResize(contentHeight, rectangle)) {
            ILayer layer = cell.getLayer();
            layer.doCommand((ILayerCommand)new RowResizeCommand(layer, cell.getRowPosition(), contentHeight + contentToCellDiff));
        }
        if (numberOfNewLines > 1) {
            String[] lines;
            int yStartPos = rectangle.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)contentHeight);
            String[] stringArray = lines = text.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                int lineContentWidth = Math.min(this.getLengthFromCache(gc, line), rectangle.width);
                Image im = Activator.getDefault().getImage("org.eclipse.papyrus.infra.nattable", "/icons/arrow_down_end.png");
                gc.drawText(line, rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)lineContentWidth) + this.spacing, yStartPos + this.spacing, 3);
                if (contentHeight > rectangle.height && yStartPos + fontHeight > rectangle.height + rectangle.y) {
                    int yDownRowIcon = rectangle.y + rectangle.height - im.getBounds().height;
                    int xDownRowIcon = rectangle.x + rectangle.width - im.getBounds().width;
                    gc.drawImage(im, xDownRowIcon, yDownRowIcon);
                }
                yStartPos += fontHeight;
                ++n2;
            }
        }
    }
}

