/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.ArrayList;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTableHandler;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractChangeLabelConfigurationValueHandler
extends AbstractTableHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ILabelProviderConfiguration editedLabelConf;
        CompositeCommand cmd = new CompositeCommand("ChangeLabelConfigurationValueCommand");
        TransactionalEditingDomain domain = (TransactionalEditingDomain)this.getTableEditingDomain();
        ILabelProviderConfiguration labelConf = this.getLabelProviderConfiguration();
        if (labelConf.eContainer() instanceof TableHeaderAxisConfiguration) {
            editedLabelConf = (ILabelProviderConfiguration)EcoreUtil.copy((EObject)labelConf);
            cmd.add((IUndoableOperation)this.getRegisterLocalLabelConfigurationCommand(labelConf, editedLabelConf));
        } else {
            editedLabelConf = labelConf;
        }
        Command command = event.getCommand();
        boolean oldValue = HandlerUtil.toggleCommandState((Command)command);
        SetRequest request = new SetRequest(domain, (EObject)editedLabelConf, this.getEditedFeature(), (Object)(!oldValue ? 1 : 0));
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)editedLabelConf);
        cmd.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        domain.getCommandStack().execute((org.eclipse.emf.common.command.Command)new GMFtoEMFCommandWrapper((ICommand)cmd));
        return null;
    }

    protected abstract ILabelProviderConfiguration getLabelProviderConfiguration();

    protected abstract EStructuralFeature getEditedFeature();

    protected ICommand getRegisterLocalLabelConfigurationCommand(ILabelProviderConfiguration tableLabelConfiguration, ILabelProviderConfiguration localTableLabelConfiguration) {
        IElementEditService provider;
        SetRequest request;
        TransactionalEditingDomain domain = (TransactionalEditingDomain)this.getTableEditingDomain();
        CompositeCommand cmd = new CompositeCommand("ChangeHeaderLabelConfigurationCommand");
        Table table = this.getCurrentNattableModelManager().getTable();
        AbstractHeaderAxisConfiguration configuration = this.getHeaderAxisConfiguration();
        LocalTableHeaderAxisConfiguration localConfig = null;
        if (configuration instanceof LocalTableHeaderAxisConfiguration) {
            localConfig = (LocalTableHeaderAxisConfiguration)configuration;
        } else if (configuration instanceof TableHeaderAxisConfiguration) {
            configuration = HeaderAxisConfigurationManagementUtils.transformToLocalHeaderConfiguration((TableHeaderAxisConfiguration)configuration);
            localConfig = (LocalTableHeaderAxisConfiguration)configuration;
            request = new SetRequest(domain, (EObject)table, this.getLocalHeaderAxisConfigurationFeature(), (Object)configuration);
            provider = ElementEditServiceUtils.getCommandProvider((Object)table);
            cmd.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        }
        request = new SetRequest(domain, (EObject)configuration, (EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getAbstractHeaderAxisConfiguration_OwnedLabelConfigurations(), (Object)localTableLabelConfiguration);
        provider = ElementEditServiceUtils.getCommandProvider((Object)configuration);
        cmd.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        TableHeaderAxisConfiguration headerAxisConfig = this.getTableHeaderAxisConfiguration();
        ArrayList<AxisManagerConfiguration> axisManagerConfiguration = new ArrayList<AxisManagerConfiguration>();
        for (AxisManagerRepresentation axisManagerRepresentation : headerAxisConfig.getAxisManagers()) {
            if (axisManagerRepresentation.getHeaderLabelConfiguration() != tableLabelConfiguration) continue;
            AxisManagerConfiguration currentConf = null;
            for (AxisManagerConfiguration axisConf : localConfig.getAxisManagerConfigurations()) {
                if (axisConf.getAxisManager() != axisManagerRepresentation) continue;
                currentConf = axisConf;
            }
            if (currentConf == null) {
                currentConf = NattableaxisconfigurationFactory.eINSTANCE.createAxisManagerConfiguration();
                currentConf.setAxisManager(axisManagerRepresentation);
                SetRequest request2 = new SetRequest(domain, (EObject)localConfig, (EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getLocalTableHeaderAxisConfiguration_AxisManagerConfigurations(), (Object)currentConf);
                IElementEditService provider2 = ElementEditServiceUtils.getCommandProvider((Object)localConfig);
                cmd.add((IUndoableOperation)provider2.getEditCommand((IEditCommandRequest)request2));
            }
            axisManagerConfiguration.add(currentConf);
        }
        for (AxisManagerConfiguration axisManagerConfiguration2 : axisManagerConfiguration) {
            SetRequest request2 = new SetRequest(domain, (EObject)axisManagerConfiguration2, (EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getAxisManagerConfiguration_LocalHeaderLabelConfiguration(), (Object)localTableLabelConfiguration);
            IElementEditService provider2 = ElementEditServiceUtils.getCommandProvider((Object)axisManagerConfiguration2);
            cmd.add((IUndoableOperation)provider2.getEditCommand((IEditCommandRequest)request2));
        }
        return cmd;
    }

    protected abstract EStructuralFeature getLocalHeaderAxisConfigurationFeature();

    protected abstract AbstractHeaderAxisConfiguration getHeaderAxisConfiguration();

    protected abstract TableHeaderAxisConfiguration getTableHeaderAxisConfiguration();
}

