/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractTableHandler
extends AbstractHandler {
    public static final String NAT_EVENT_DATA_PARAMETER_ID = "natEventParameterId";
    protected NatEventData eventData;

    protected IWorkbenchPart getActivePart() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
    }

    protected INattableModelManager getCurrentNattableModelManager() {
        IWorkbenchPart currentPart = this.getActivePart();
        if (currentPart != null) {
            INattableModelManager manager = (INattableModelManager)currentPart.getAdapter(INattableModelManager.class);
            return manager;
        }
        return null;
    }

    protected EditingDomain getTableEditingDomain() {
        ServicesRegistry registry = null;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)this.getCurrentNattableModelManager().getTable());
            return (EditingDomain)registry.getService(EditingDomain.class);
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.NattableModelManager_ServiceRegistryNotFound, (Throwable)e);
            return null;
        }
    }

    protected EditingDomain getContextEditingDomain() {
        ServicesRegistry registry = null;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)this.getCurrentNattableModelManager().getTable());
            return (EditingDomain)registry.getService(EditingDomain.class);
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.NattableModelManager_ServiceRegistryNotFound, (Throwable)e);
            return null;
        }
    }

    protected NatEventData getNatEventData(Object evaluationContext) {
        Object value;
        if (evaluationContext instanceof NatEventData) {
            return (NatEventData)evaluationContext;
        }
        NatEventData eventData = null;
        if (evaluationContext instanceof IEvaluationContext && (value = ((IEvaluationContext)evaluationContext).getVariable(NAT_EVENT_DATA_PARAMETER_ID)) instanceof NatEventData) {
            eventData = (NatEventData)value;
        }
        if (eventData == null) {
            Point cursorLocation = Display.getDefault().getCursorLocation();
            Control control = Display.getDefault().getCursorControl();
            if (control instanceof NatTable) {
                cursorLocation = control.toControl(cursorLocation);
                Event e = new Event();
                e.x = cursorLocation.x;
                e.y = cursorLocation.y;
                e.display = Display.getDefault();
                e.widget = control;
                MouseEvent event = new MouseEvent(e);
                eventData = NatEventData.createInstanceFromEvent((MouseEvent)event);
            }
        }
        return eventData;
    }

    protected List<Integer> getFullSelectedRowsIndex(Object evaluationContext) {
        NatEventData data;
        INattableModelManager manager = this.getCurrentNattableModelManager();
        if (manager != null && (data = this.getNatEventData(evaluationContext)) != null) {
            SelectionLayer layer = manager.getBodyLayerStack().getSelectionLayer();
            int[] fullSelectedColumnsPosition = layer.getFullySelectedRowPositions();
            ArrayList<Integer> positions = new ArrayList<Integer>();
            int[] nArray = fullSelectedColumnsPosition;
            int n = fullSelectedColumnsPosition.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                positions.add(layer.getRowIndexByPosition(i));
                ++n2;
            }
            return positions;
        }
        return Collections.emptyList();
    }

    protected List<Integer> getFullSelectedColumnsIndex(Object evaluationContext) {
        NatEventData data;
        INattableModelManager manager = this.getCurrentNattableModelManager();
        if (manager != null && (data = this.getNatEventData(evaluationContext)) != null) {
            SelectionLayer layer = manager.getBodyLayerStack().getSelectionLayer();
            int[] fullSelectedColumnsPosition = layer.getFullySelectedColumnPositions();
            ArrayList<Integer> positions = new ArrayList<Integer>();
            int[] nArray = fullSelectedColumnsPosition;
            int n = fullSelectedColumnsPosition.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                positions.add(layer.getColumnIndexByPosition(i));
                ++n2;
            }
            return positions;
        }
        return Collections.emptyList();
    }

    protected IAxisManager getRowAxisManager() {
        INattableModelManager manager = this.getCurrentNattableModelManager();
        if (manager != null) {
            return manager.getRowAxisManager();
        }
        return null;
    }

    protected IAxisManager getColumnAxisManager() {
        INattableModelManager manager = this.getCurrentNattableModelManager();
        if (manager != null) {
            return manager.getColumnAxisManager();
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.eventData = this.getNatEventData(evaluationContext);
        this.setBaseEnabled(this.getCurrentNattableModelManager() != null);
    }
}

