/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.listener;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.LocationValue;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;

public class NatTableDropListener
implements DropTargetListener {
    private final INattableModelManager manager;
    private LocationValue dropKindValue;

    public NatTableDropListener(INattableModelManager manager) {
        this.manager = manager;
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
        this.dropKindValue = null;
        LocalTransfer localTransfer = LocalTransfer.getInstance();
        Object data = localTransfer.nativeToJava(event.currentDataType);
        IStructuredSelection structuredSelection = null;
        if (data instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)data;
        }
        Collection<Object> objectsToAdd = Collections.checkedCollection(structuredSelection.toList(), Object.class);
        this.dropKindValue = this.manager.getLocationInTheTable(new Point(event.x, event.y));
        int drop = 0;
        switch (this.dropKindValue.getKind()) {
            case AFTER_COLUMN_HEADER: {
                if (!this.manager.canDropColumnsElement(objectsToAdd)) break;
                drop = 16;
                break;
            }
            case AFTER_ROW_HEADER: {
                if (!this.manager.canDropRowElement(objectsToAdd)) break;
                drop = 16;
                break;
            }
            case COLUMN_HEADER: {
                if (!this.manager.canInsertColumns(objectsToAdd, this.dropKindValue.getColumnIndex())) break;
                drop = 16;
                break;
            }
            case ROW_HEADER: {
                if (!this.manager.canInsertRow(objectsToAdd, this.dropKindValue.getRowIndex())) break;
                drop = 16;
                break;
            }
            case CELL: {
                drop = 0;
                break;
            }
            case UNKNOWN: {
                drop = 0;
                break;
            }
            default: {
                drop = 0;
            }
        }
        event.detail = drop;
    }

    public void drop(DropTargetEvent event) {
        LocalTransfer localTransfer = LocalTransfer.getInstance();
        Object data = localTransfer.nativeToJava(event.currentDataType);
        if (data instanceof StructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)data;
            List droppedElements = selection.toList();
            if (this.dropKindValue != null) {
                switch (this.dropKindValue.getKind()) {
                    case AFTER_COLUMN_HEADER: {
                        this.manager.addColumns(droppedElements);
                        break;
                    }
                    case AFTER_ROW_HEADER: {
                        this.manager.addRows(droppedElements);
                        break;
                    }
                    case COLUMN_HEADER: {
                        this.manager.insertColumns(droppedElements, this.dropKindValue.getColumnIndex());
                        break;
                    }
                    case ROW_HEADER: {
                        this.manager.insertRows(droppedElements, this.dropKindValue.getRowIndex());
                        break;
                    }
                    case CELL: {
                        break;
                    }
                    case UNKNOWN: {
                        break;
                    }
                }
            }
        }
        this.dropKindValue = null;
    }

    public void dropAccept(DropTargetEvent event) {
    }
}

