/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.axis;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.InputDialogWithLocation;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractAxisManager
implements IAxisManager {
    protected AxisManagerRepresentation representedAxisManager;
    private AbstractAxisProvider representedContentProvider;
    protected INattableModelManager tableManager;
    protected Adapter axisListener;
    private EObject tableContext;

    @Override
    public void init(INattableModelManager manager, AxisManagerRepresentation rep, AbstractAxisProvider provider) {
        this.tableManager = manager;
        this.representedAxisManager = rep;
        this.representedContentProvider = provider;
        this.tableContext = manager.getTable().getContext();
        this.axisListener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                AbstractAxisManager.this.getTableManager().updateAxisContents(AbstractAxisManager.this.getRepresentedContentProvider());
            }
        };
        this.representedContentProvider.eAdapters().add((Object)this.axisListener);
    }

    @Override
    public NattableModelManager getTableManager() {
        return (NattableModelManager)this.tableManager;
    }

    @Override
    public boolean canInsertAxis(Collection<Object> objectsToAdd, int index) {
        return false;
    }

    @Override
    public boolean canCreateAxisElement(String elementId) {
        return false;
    }

    @Override
    public boolean canDropAxisElement(Collection<Object> objectsToAdd) {
        return false;
    }

    public void dispose() {
        if (this.axisListener != null) {
            this.representedContentProvider.eAdapters().remove((Object)this.axisListener);
            this.axisListener = null;
        }
        this.tableContext = null;
    }

    @Override
    public boolean canBeUsedAsRowManager() {
        return true;
    }

    @Override
    public boolean canBeUsedAsColumnManager() {
        return true;
    }

    @Override
    public Command getAddAxisCommand(EditingDomain domain, Collection<Object> objectToAdd) {
        return null;
    }

    @Override
    public Command getInsertAxisCommand(Collection<Object> objectsToAdd, int index) {
        return null;
    }

    @Override
    public Command getComplementaryAddAxisCommand(EditingDomain domain, Collection<Object> objectToAdd) {
        return null;
    }

    @Override
    public AbstractAxisProvider getRepresentedContentProvider() {
        return this.representedContentProvider;
    }

    @Override
    public void setHeaderDataValue(int columnIndex, int rowIndex, Object newValue) {
    }

    @Override
    public boolean isAllowedContents(Object object) {
        return !this.getTableManager().getElementsList(this.getRepresentedContentProvider()).contains(object);
    }

    @Override
    public boolean canMoveAxis() {
        return true;
    }

    @Override
    public IRestrictedContentProvider createPossibleAxisContentProvider(boolean isRestricted) {
        return null;
    }

    @Override
    public Command getDestroyAxisCommand(EditingDomain domain, Collection<Object> objectToDestroy) {
        return null;
    }

    protected final EObject getTableContext() {
        return this.tableContext;
    }

    @Override
    public Collection<Object> getAllManagedAxis() {
        HashSet<Object> eObjects = new HashSet<Object>();
        for (IAxis current : this.getRepresentedContentProvider().getAxis()) {
            if (current.getManager() != this.representedAxisManager) continue;
            eObjects.add(current.getElement());
        }
        return eObjects;
    }

    protected EditingDomain getTableEditingDomain() {
        ServicesRegistry registry = null;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)this.getTableManager().getTable());
            return (EditingDomain)registry.getService(EditingDomain.class);
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.NattableModelManager_ServiceRegistryNotFound, (Throwable)e);
            return null;
        }
    }

    protected EditingDomain getContextEditingDomain() {
        ServicesRegistry registry = null;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(this.getTableContext());
            return (EditingDomain)registry.getService(TransactionalEditingDomain.class);
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.NattableModelManager_ServiceRegistryNotFound, (Throwable)e);
            return null;
        }
    }

    @Override
    public void moveAxis(Object elementToMove, int newIndex) {
    }

    @Override
    public void openEditAxisAliasDialog(NatEventData event, int axisPosition) {
        IAxis axis = (IAxis)this.representedContentProvider.getAxis().get(axisPosition);
        String alias = axis.getAlias();
        if (alias == null) {
            alias = "";
        }
        String dialogMessage = String.format(Messages.AbstractAxisManager_InputDialogMessage, this.getElementAxisName(axis));
        Point location = new Point(event.getOriginalEvent().x, event.getOriginalEvent().y);
        NatTable natTable = event.getNatTable();
        location = natTable.toDisplay(location);
        InputDialogWithLocation dialog = new InputDialogWithLocation(Display.getDefault().getActiveShell(), Messages.AbstractAxisManager_InputDialogTitle, dialogMessage, alias, null, location);
        int result = dialog.open();
        if (result == 0) {
            String newAlias = dialog.getText();
            if ("".equals(newAlias)) {
                newAlias = null;
            }
            TransactionalEditingDomain domain = (TransactionalEditingDomain)this.getTableEditingDomain();
            SetRequest request = new SetRequest(domain, (EObject)axis, (EStructuralFeature)NattableaxisPackage.eINSTANCE.getIAxis_Alias(), (Object)newAlias);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)axis);
            ICommand cmd = provider.getEditCommand((IEditCommandRequest)request);
            domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(cmd));
        }
    }

    @Override
    public String getElementAxisName(IAxis axis) {
        if (this.canEditAxisHeader()) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public AxisManagerRepresentation getAxisManagerRepresentation() {
        return this.representedAxisManager;
    }

    @Override
    public boolean canDestroyAxis(List<Integer> axisPositions) {
        if (axisPositions.isEmpty()) {
            return false;
        }
        for (Integer integer : axisPositions) {
            if (this.canDestroyAxis(integer)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canDestroyAxisElement(List<Integer> axisPositions) {
        if (axisPositions.isEmpty()) {
            return false;
        }
        for (Integer integer : axisPositions) {
            if (this.canDestroyAxisElement(integer)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void destroyAxis(List<Integer> axisPositions) {
        List<Object> toDestroy = this.getElements(axisPositions);
        EditingDomain domain = this.getTableEditingDomain();
        Command cmd = this.getDestroyAxisCommand(domain, toDestroy);
        domain.getCommandStack().execute(cmd);
    }

    @Override
    public boolean canDestroyAxis(Integer axisPosition) {
        return !this.isDynamic();
    }

    protected List<Object> getElements(List<Integer> axisPositions) {
        List<Object> elements = this.getElements();
        for (Integer position : axisPositions) {
            Object element = elements.get(position);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public void destroyAxisElement(List<Integer> axisPosition) {
        CompoundCommand cmd = new CompoundCommand("Destroy Axis Element Command");
        EditingDomain domain = this.getContextEditingDomain();
        for (Integer integer : axisPosition) {
            cmd.append(this.getDestroyAxisElementCommand(domain, integer));
        }
        domain.getCommandStack().execute((Command)cmd);
    }

    protected List<Object> getElements() {
        return this.tableManager.getElementsList(this.getRepresentedContentProvider());
    }
}

