/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.EStructuralFeatureValueFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;

public abstract class AbstractSynchronizedOnFeatureAxisManager
extends AbstractAxisManager {
    protected Adapter featureListener;
    protected EStructuralFeature currentListenFeature;

    @Override
    public void init(INattableModelManager manager, AxisManagerRepresentation rep, AbstractAxisProvider provider) {
        super.init(manager, rep, provider);
        this.verifyValues();
        this.currentListenFeature = this.getListenFeature();
        this.addContextFeatureValueListener();
    }

    protected void addContextFeatureValueListener() {
        this.featureListener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeature() == AbstractSynchronizedOnFeatureAxisManager.this.currentListenFeature) {
                    AbstractSynchronizedOnFeatureAxisManager.this.getTableManager().updateAxisContents(AbstractSynchronizedOnFeatureAxisManager.this.getRepresentedContentProvider());
                }
            }
        };
        this.getTableContext().eAdapters().add((Object)this.featureListener);
    }

    protected void verifyValues() {
        Assert.isNotNull((Object)(this.getFillingConfiguration() != null ? 1 : 0));
        this.verifyCoupleContextFeature();
    }

    protected EStructuralFeature getListenFeature() {
        EStructuralFeatureValueFillingConfiguration config = this.getFillingConfiguration();
        if (config != null) {
            return config.getListenFeature();
        }
        return null;
    }

    protected EStructuralFeatureValueFillingConfiguration getFillingConfiguration() {
        for (IAxisConfiguration current : this.representedAxisManager.getSpecificAxisConfigurations()) {
            if (!(current instanceof EStructuralFeatureValueFillingConfiguration)) continue;
            return (EStructuralFeatureValueFillingConfiguration)current;
        }
        return null;
    }

    @Override
    public void dispose() {
        this.getTableContext().eAdapters().remove((Object)this.featureListener);
        super.dispose();
    }

    protected void verifyCoupleContextFeature() {
        EStructuralFeature feature = this.getListenFeature();
        if (feature != null) {
            Assert.isTrue((boolean)feature.isMany());
            Assert.isTrue((boolean)this.getTableManager().getTable().getContext().eClass().getEAllStructuralFeatures().contains((Object)feature));
        }
    }

    @Override
    public boolean canDropAxisElement(Collection<Object> objectsToAdd) {
        return false;
    }

    @Override
    public boolean canInsertAxis(Collection<Object> objectsToAdd, int index) {
        return false;
    }

    @Override
    public Collection<Object> getAllManagedAxis() {
        EObject context = this.getTableContext();
        Object value = this.currentListenFeature != null ? context.eGet(this.currentListenFeature) : context.eGet(this.getListenFeature());
        assert (value instanceof List);
        List<Object> interestingObject = this.filterObject((List)value);
        interestingObject = this.sortObjects(interestingObject);
        return interestingObject;
    }

    protected List<Object> sortObjects(Collection<Object> objects) {
        return new ArrayList<Object>(objects);
    }

    protected List<Object> filterObject(List<?> objects) {
        return new ArrayList<Object>(objects);
    }

    @Override
    public boolean canMoveAxis() {
        return false;
    }

    @Override
    public final boolean isDynamic() {
        return true;
    }

    @Override
    public boolean isSlave() {
        return false;
    }

    @Override
    public boolean canEditAxisHeader() {
        return false;
    }
}

