/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.ICompositeAxisManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.utils.AxisComparator;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.providers.CompoundFilteredRestrictedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;

public class CompositeAxisManager
extends AbstractAxisManager
implements ICompositeAxisManager {
    private static final String MANAGER_ID = "org.eclipse.papyrus.infra.nattable.composite.axis.manager";
    protected List<IAxisManager> subManagers;

    @Override
    public void setSubAxisManager(List<IAxisManager> managers) {
        this.subManagers = managers;
        this.updateAxisContents();
    }

    @Override
    public void dispose() {
        for (IAxisManager current : this.subManagers) {
            current.dispose();
        }
        this.subManagers.clear();
    }

    @Override
    public boolean canBeUsedAsRowManager() {
        boolean answer = true;
        Iterator<IAxisManager> iter = this.subManagers.iterator();
        while (iter.hasNext() && answer) {
            answer = iter.next().canBeUsedAsRowManager();
        }
        return answer;
    }

    @Override
    public boolean canBeUsedAsColumnManager() {
        boolean answer = true;
        Iterator<IAxisManager> iter = this.subManagers.iterator();
        while (iter.hasNext() && answer) {
            answer = iter.next().canBeUsedAsColumnManager();
        }
        return answer;
    }

    @Override
    public boolean canCreateAxisElement(String elementId) {
        boolean canCreateAxisElement = false;
        for (IAxisManager manager : this.subManagers) {
            canCreateAxisElement |= manager.canCreateAxisElement(elementId);
        }
        return canCreateAxisElement;
    }

    @Override
    public Command getAddAxisCommand(EditingDomain domain, Collection<Object> objectToAdd) {
        CompoundCommand cmd = new CompoundCommand(Messages.CompositeAxisManager_AddAxisCommand);
        for (IAxisManager current : this.subManagers) {
            Command tmp = current.getAddAxisCommand(domain, objectToAdd);
            if (tmp == null) continue;
            cmd.append(tmp);
        }
        if (cmd.isEmpty()) {
            return null;
        }
        return cmd;
    }

    @Override
    public Command getComplementaryAddAxisCommand(EditingDomain domain, Collection<Object> objectToAdd) {
        CompoundCommand cmd = new CompoundCommand(Messages.CompositeAxisManager_AddAxisCommand);
        for (IAxisManager current : this.subManagers) {
            Command tmp = current.getComplementaryAddAxisCommand(domain, objectToAdd);
            if (tmp == null) continue;
            cmd.append(tmp);
        }
        if (cmd.isEmpty()) {
            return null;
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateAxisContents() {
        List<Object> displayedElement;
        List<Object> list = displayedElement = this.getTableManager().getElementsList(this.getRepresentedContentProvider());
        synchronized (list) {
            displayedElement.clear();
            displayedElement.addAll((Collection<Object>)this.getRepresentedContentProvider().getAxis());
            if (this.subManagers != null) {
                for (IAxisManager current : this.subManagers) {
                    if (!current.isDynamic()) continue;
                    displayedElement.addAll(current.getAllManagedAxis());
                }
            }
        }
    }

    @Override
    public boolean isAllowedContents(Object object) {
        for (IAxisManager current : this.subManagers) {
            if (!current.isAllowedContents(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canMoveAxis() {
        for (IAxisManager current : this.subManagers) {
            if (current.canMoveAxis() && !current.isDynamic()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void sortAxisByName(boolean alphabeticOrder, IConfigRegistry configRegistry) {
        if (this.canMoveAxis()) {
            ArrayList axis = new ArrayList(this.getRepresentedContentProvider().getAxis());
            Collections.sort(axis, new AxisComparator(alphabeticOrder, configRegistry));
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.getRepresentedContentProvider());
            SetRequest request = new SetRequest(domain, (EObject)this.getRepresentedContentProvider(), (EStructuralFeature)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), axis);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.getRepresentedContentProvider());
            ICommand cmd = provider.getEditCommand((IEditCommandRequest)request);
            domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(cmd));
        }
    }

    @Override
    public IRestrictedContentProvider createPossibleAxisContentProvider(boolean isRestricted) {
        CompoundFilteredRestrictedContentProvider compoundContentProvider = null;
        for (IAxisManager current : this.subManagers) {
            IRestrictedContentProvider contentProvider = current.createPossibleAxisContentProvider(isRestricted);
            if (contentProvider == null) continue;
            if (compoundContentProvider == null) {
                compoundContentProvider = new CompoundFilteredRestrictedContentProvider();
            }
            compoundContentProvider.add(contentProvider);
        }
        return compoundContentProvider;
    }

    @Override
    public Command getDestroyAxisCommand(EditingDomain domain, Collection<Object> objectToDestroy) {
        CompoundCommand cmd = new CompoundCommand(Messages.CompositeAxisManager_DestroyAxisCommand);
        for (IAxisManager current : this.subManagers) {
            Command tmp = current.getDestroyAxisCommand(domain, objectToDestroy);
            if (tmp == null) continue;
            cmd.append(tmp);
        }
        if (cmd.isEmpty()) {
            return null;
        }
        return cmd;
    }

    @Override
    public Collection<Object> getAllManagedAxis() {
        HashSet<Object> allExistingAxis = new HashSet<Object>();
        for (IAxisManager manager : this.subManagers) {
            Collection<Object> managerPossibleElements = manager.getAllManagedAxis();
            if (managerPossibleElements == null) continue;
            allExistingAxis.addAll(managerPossibleElements);
        }
        return allExistingAxis;
    }

    @Override
    public boolean isSlave() {
        for (IAxisManager manager : this.subManagers) {
            if (!manager.isSlave()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDynamic() {
        for (IAxisManager manager : this.subManagers) {
            if (!manager.isDynamic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canDropAxisElement(Collection<Object> objectsToAdd) {
        for (IAxisManager current : this.subManagers) {
            if (!current.canDropAxisElement(objectsToAdd)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void moveAxis(Object elementToMove, int newIndex) {
        if (!this.isDynamic() && elementToMove instanceof IAxis) {
            EditingDomain domain = this.getTableEditingDomain();
            Command command = MoveCommand.create((EditingDomain)domain, (Object)this.getRepresentedContentProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), (Object)elementToMove, (int)newIndex);
            domain.getCommandStack().execute(command);
        }
    }

    @Override
    public boolean canEditAxisHeader(NatEventData axisIndex) {
        axisIndex.getColumnPosition();
        return this.canEditAxisHeader();
    }

    @Override
    public boolean canEditAxisHeader() {
        for (IAxisManager current : this.subManagers) {
            if (current.canEditAxisHeader()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getElementAxisName(IAxis axis) {
        AxisManagerRepresentation manager = axis.getManager();
        for (IAxisManager man : this.subManagers) {
            if (man.getAxisManagerRepresentation() != manager) continue;
            return man.getElementAxisName(axis);
        }
        if (this.canEditAxisHeader()) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    protected IAxisManager getAxisManager(IAxis axis) {
        AxisManagerRepresentation rep = axis.getManager();
        for (IAxisManager man : this.subManagers) {
            if (man.getAxisManagerRepresentation() != rep) continue;
            return man;
        }
        return null;
    }

    @Override
    public boolean canDestroyAxis(Integer axisPosition) {
        List<Object> elements = this.tableManager.getElementsList(this.getRepresentedContentProvider());
        Object element = elements.get(axisPosition);
        if (element instanceof IAxis) {
            return this.getAxisManager((IAxis)element).canDestroyAxis(axisPosition);
        }
        return false;
    }

    @Override
    public boolean canDestroyAxisElement(Integer axisPosition) {
        List<Object> elements = this.tableManager.getElementsList(this.getRepresentedContentProvider());
        Object element = elements.get(axisPosition);
        if (element instanceof IAxis) {
            return this.getAxisManager((IAxis)element).canDestroyAxisElement(axisPosition);
        }
        if (this.subManagers.size() == 1) {
            return this.subManagers.get(0).canDestroyAxisElement(axisPosition);
        }
        return false;
    }

    @Override
    public Command getDestroyAxisElementCommand(EditingDomain domain, Integer axisPosition) {
        List<Object> elements = this.tableManager.getElementsList(this.getRepresentedContentProvider());
        Object element = elements.get(axisPosition);
        if (element instanceof IAxis) {
            return this.getAxisManager((IAxis)element).getDestroyAxisElementCommand(domain, axisPosition);
        }
        if (this.subManagers.size() == 1) {
            return this.subManagers.get(0).getDestroyAxisElementCommand(domain, axisPosition);
        }
        return UnexecutableCommand.INSTANCE;
    }
}

