/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.cell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.nattable.manager.cell.ICellManager;

public class CellManagerFactory {
    public static final String CLASS_MANAGER = "manager";
    public static final String ORDER = "order";
    public static final String SOLVER_ID = "id";
    private final Collection<ICellManager> solvers = new ArrayList<ICellManager>();
    private final Map<Integer, ICellManager> managersMap = new TreeMap<Integer, ICellManager>();
    private static final String EXTENSION_ID = "org.eclipse.papyrus.infra.nattable.cellmanager";
    public static final CellManagerFactory INSTANCE = new CellManagerFactory();

    private CellManagerFactory() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String id = iConfigurationElement.getAttribute(SOLVER_ID);
            Integer order = new Integer(iConfigurationElement.getAttribute(ORDER));
            try {
                ICellManager solver = (ICellManager)iConfigurationElement.createExecutableExtension(CLASS_MANAGER);
                this.managersMap.put(order, solver);
                this.solvers.add(solver);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public Object getCrossValue(Object obj1, Object obj2) {
        ICellManager cellManager = this.getCrossValueSolver(obj1, obj2);
        if (cellManager != null) {
            return cellManager.getValue(obj1, obj2);
        }
        return null;
    }

    private ICellManager getCrossValueSolver(Object obj1, Object obj2) {
        for (Integer integer : this.managersMap.keySet()) {
            ICellManager current = this.managersMap.get(integer);
            if (!current.handles(obj1, obj2)) continue;
            return current;
        }
        return null;
    }

    public boolean isCellEditable(Object obj1, Object obj2) {
        ICellManager cellManager = this.getCrossValueSolver(obj1, obj2);
        if (cellManager != null) {
            return cellManager.isCellEditable(obj1, obj2);
        }
        return false;
    }

    public void setCellValue(EditingDomain domain, Object obj1, Object obj2, Object newValue) {
        ICellManager cellManager = this.getCrossValueSolver(obj1, obj2);
        if (cellManager != null) {
            cellManager.setValue(domain, obj1, obj2, newValue);
        }
    }
}

